/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.wildfly.clustering.server.GroupCapabilityServiceBuilderFactory;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.spi.ClusteringRequirement;
import org.wildfly.clustering.spi.GroupBuilderProvider;
import org.wildfly.clustering.spi.ServiceNameRegistry;

public class GroupRequirementBuilderProvider<T>
implements GroupBuilderProvider {
    private final ClusteringRequirement requirement;
    private final GroupCapabilityServiceBuilderFactory<T> factory;
    private final Function<String, JndiName> jndiNameFactory;

    protected GroupRequirementBuilderProvider(ClusteringRequirement requirement, GroupCapabilityServiceBuilderFactory<T> factory) {
        this(requirement, factory, null);
    }

    protected GroupRequirementBuilderProvider(ClusteringRequirement requirement, GroupCapabilityServiceBuilderFactory<T> factory, Function<String, JndiName> jndiNameFactory) {
        this.requirement = requirement;
        this.factory = factory;
        this.jndiNameFactory = jndiNameFactory;
    }

    public Collection<CapabilityServiceBuilder<?>> getBuilders(ServiceNameRegistry<ClusteringRequirement> registry, String group) {
        CapabilityServiceBuilder<T> builder = this.factory.createBuilder(registry.getServiceName((Requirement)this.requirement), group);
        if (this.jndiNameFactory == null) {
            return Collections.singleton(builder);
        }
        ContextNames.BindInfo binding = ContextNames.bindInfoFor((String)this.jndiNameFactory.apply(group).getAbsoluteName());
        BinderServiceBuilder binderBuilder = new BinderServiceBuilder(binding, builder.getServiceName(), this.requirement.getType());
        return Arrays.asList(builder, binderBuilder);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

