/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import org.keycloak.authorization.jpa.entities.ResourceEntity;
import org.keycloak.authorization.jpa.entities.ScopeEntity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.jpa.JpaModel;

public class ResourceAdapter
implements Resource,
JpaModel<ResourceEntity> {
    private ResourceEntity entity;
    private EntityManager em;
    private StoreFactory storeFactory;

    public ResourceAdapter(ResourceEntity entity, EntityManager em, StoreFactory storeFactory) {
        this.entity = entity;
        this.em = em;
        this.storeFactory = storeFactory;
    }

    @Override
    public ResourceEntity getEntity() {
        return this.entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public String getName() {
        return this.entity.getName();
    }

    public String getDisplayName() {
        return this.entity.getDisplayName();
    }

    public void setDisplayName(String name) {
        this.entity.setDisplayName(name);
    }

    public void setName(String name) {
        this.entity.setName(name);
    }

    public String getUri() {
        return this.entity.getUri();
    }

    public void setUri(String uri) {
        this.entity.setUri(uri);
    }

    public String getType() {
        return this.entity.getType();
    }

    public void setType(String type) {
        this.entity.setType(type);
    }

    public List<Scope> getScopes() {
        LinkedList<Scope> scopes = new LinkedList<Scope>();
        for (ScopeEntity scope : this.entity.getScopes()) {
            scopes.add(this.storeFactory.getScopeStore().findById(scope.getId(), this.entity.getResourceServer().getId()));
        }
        return Collections.unmodifiableList(scopes);
    }

    public String getIconUri() {
        return this.entity.getIconUri();
    }

    public void setIconUri(String iconUri) {
        this.entity.setIconUri(iconUri);
    }

    public ResourceServer getResourceServer() {
        return this.storeFactory.getResourceServerStore().findById(this.entity.getResourceServer().getId());
    }

    public String getOwner() {
        return this.entity.getOwner();
    }

    public boolean isOwnerManagedAccess() {
        return this.entity.isOwnerManagedAccess();
    }

    public void setOwnerManagedAccess(boolean ownerManagedAccess) {
        this.entity.setOwnerManagedAccess(ownerManagedAccess);
    }

    public void updateScopes(Set<Scope> toUpdate) {
        HashSet<String> ids = new HashSet<String>();
        for (Scope scope : toUpdate) {
            ids.add(scope.getId());
        }
        Iterator<ScopeEntity> it = this.entity.getScopes().iterator();
        while (it.hasNext()) {
            ScopeEntity next = it.next();
            if (!ids.contains(next.getId())) {
                it.remove();
                continue;
            }
            ids.remove(next.getId());
        }
        for (String addId : ids) {
            this.entity.getScopes().add((ScopeEntity)this.em.getReference(ScopeEntity.class, (Object)addId));
        }
    }

    public static ResourceEntity toEntity(EntityManager em, Resource resource) {
        if (resource instanceof ResourceAdapter) {
            return ((ResourceAdapter)resource).getEntity();
        }
        return (ResourceEntity)em.getReference(ResourceEntity.class, (Object)resource.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Resource)) {
            return false;
        }
        Resource that = (Resource)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

