/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.keycloak.models.jpa.entities.CredentialAttributeEntity;
import org.keycloak.models.jpa.entities.UserEntity;

@NamedQueries(value={@NamedQuery(name="credentialByUser", query="select cred from CredentialEntity cred where cred.user = :user"), @NamedQuery(name="credentialByUserAndType", query="select cred from CredentialEntity cred where cred.user = :user and cred.type = :type"), @NamedQuery(name="credentialByNameAndType", query="select cred from CredentialEntity cred where cred.user = :user and cred.type = :type and cred.device = :device"), @NamedQuery(name="deleteCredentialsByRealm", query="delete from CredentialEntity cred where cred.user IN (select u from UserEntity u where u.realmId=:realmId)"), @NamedQuery(name="deleteCredentialsByRealmAndLink", query="delete from CredentialEntity cred where cred.user IN (select u from UserEntity u where u.realmId=:realmId and u.federationLink=:link)")})
@Table(name="CREDENTIAL")
@Entity
public class CredentialEntity {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    protected String id;
    @Column(name="TYPE")
    protected String type;
    @Column(name="VALUE")
    protected String value;
    @Column(name="DEVICE")
    protected String device;
    @Column(name="SALT")
    protected byte[] salt;
    @Column(name="HASH_ITERATIONS")
    protected int hashIterations;
    @Column(name="CREATED_DATE")
    protected Long createdDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="USER_ID")
    protected UserEntity user;
    @Column(name="COUNTER")
    protected int counter;
    @Column(name="ALGORITHM")
    protected String algorithm;
    @Column(name="DIGITS")
    protected int digits;
    @Column(name="PERIOD")
    protected int period;
    @OneToMany(cascade={CascadeType.REMOVE}, fetch=FetchType.EAGER, orphanRemoval=true, mappedBy="credential")
    protected Collection<CredentialAttributeEntity> credentialAttributes = new ArrayList<CredentialAttributeEntity>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDevice() {
        return this.device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public UserEntity getUser() {
        return this.user;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public void setSalt(byte[] salt) {
        this.salt = salt;
    }

    public int getHashIterations() {
        return this.hashIterations;
    }

    public void setHashIterations(int hashIterations) {
        this.hashIterations = hashIterations;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public int getDigits() {
        return this.digits;
    }

    public void setDigits(int digits) {
        this.digits = digits;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public Collection<CredentialAttributeEntity> getCredentialAttributes() {
        return this.credentialAttributes;
    }

    public void setCredentialAttributes(Collection<CredentialAttributeEntity> credentialAttributes) {
        this.credentialAttributes = credentialAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof CredentialEntity)) {
            return false;
        }
        CredentialEntity that = (CredentialEntity)o;
        return this.id.equals(that.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

