/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm.authorization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceOwnerRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;

public class ResourceRepresentation {
    @JsonProperty(value="_id")
    private String id;
    private String name;
    private String uri;
    private String type;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<ScopeRepresentation> scopes;
    @JsonProperty(value="icon_uri")
    private String iconUri;
    private ResourceOwnerRepresentation owner;
    private Boolean ownerManagedAccess;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<PolicyRepresentation> policies;
    private String displayName;

    public ResourceRepresentation(String name, Set<ScopeRepresentation> scopes, String uri, String type, String iconUri) {
        this.name = name;
        this.scopes = scopes;
        this.uri = uri;
        this.type = type;
        this.iconUri = iconUri;
    }

    public ResourceRepresentation(String name, Set<ScopeRepresentation> scopes, String uri, String type) {
        this(name, scopes, uri, type, null);
    }

    public ResourceRepresentation(String name, Set<ScopeRepresentation> scopes) {
        this(name, scopes, null, null, null);
    }

    public ResourceRepresentation(String name, String ... scopes) {
        this.name = name;
        this.scopes = new HashSet<ScopeRepresentation>();
        for (String s : scopes) {
            ScopeRepresentation rep = new ScopeRepresentation(s);
            this.scopes.add(rep);
        }
    }

    public ResourceRepresentation() {
        this((String)null, (Set<ScopeRepresentation>)null, (String)null, (String)null, (String)null);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUri() {
        return this.uri;
    }

    public String getType() {
        return this.type;
    }

    public Set<ScopeRepresentation> getScopes() {
        if (this.scopes == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.scopes);
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setScopes(Set<ScopeRepresentation> scopes) {
        this.scopes = scopes;
    }

    public void setIconUri(String iconUri) {
        this.iconUri = iconUri;
    }

    public ResourceOwnerRepresentation getOwner() {
        return this.owner;
    }

    public void setOwner(ResourceOwnerRepresentation owner) {
        this.owner = owner;
    }

    public Boolean getOwnerManagedAccess() {
        return this.ownerManagedAccess;
    }

    public void setOwnerManagedAccess(Boolean ownerManagedAccess) {
        this.ownerManagedAccess = ownerManagedAccess;
    }

    public void addScope(String ... scopeNames) {
        if (this.scopes == null) {
            this.scopes = new HashSet<ScopeRepresentation>();
        }
        for (String scopeName : scopeNames) {
            this.scopes.add(new ScopeRepresentation(scopeName));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceRepresentation scope = (ResourceRepresentation)o;
        return Objects.equals(this.getName(), scope.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }
}

