/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.LayeredModulePathFactory;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.modules.xml.ModuleXmlParser;

public final class LocalModuleFinder
implements ModuleFinder,
AutoCloseable {
    private static final File[] NO_FILES = new File[0];
    private final File[] repoRoots;
    private final PathFilter pathFilter;
    private final AccessControlContext accessControlContext;
    private final List<ResourceLoader> resourceLoaderList = new ArrayList<ResourceLoader>(64);
    private final ModuleXmlParser.ResourceRootFactory resourceRootFactory;
    private static final ResourceLoader TERMINATED_MARKER = new ResourceLoader(){

        @Override
        public String getRootName() {
            return null;
        }

        @Override
        public ClassSpec getClassSpec(String fileName) throws IOException {
            return null;
        }

        @Override
        public PackageSpec getPackageSpec(String name) throws IOException {
            return null;
        }

        @Override
        public Resource getResource(String name) {
            return null;
        }

        @Override
        public String getLibrary(String name) {
            return null;
        }

        @Override
        public Collection<String> getPaths() {
            return null;
        }
    };

    private LocalModuleFinder(File[] repoRoots, PathFilter pathFilter, boolean cloneRoots) {
        this.repoRoots = cloneRoots && repoRoots.length > 0 ? (File[])repoRoots.clone() : repoRoots;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            for (File repoRoot : this.repoRoots) {
                if (repoRoot != null) continue;
                sm.checkPermission(new FilePermission(new File(repoRoot, "-").getPath(), "read"));
            }
        }
        this.pathFilter = pathFilter;
        this.accessControlContext = AccessController.getContext();
        this.resourceRootFactory = (rootPath, loaderPath, loaderName) -> {
            List<ResourceLoader> list;
            ResourceLoader loader = ModuleXmlParser.ResourceRootFactory.getDefault().createResourceLoader(rootPath, loaderPath, loaderName);
            List<ResourceLoader> list2 = list = this.resourceLoaderList;
            synchronized (list2) {
                if (list.size() == 1 && list.get(0) == TERMINATED_MARKER) {
                    LocalModuleFinder.safeClose(loader);
                    throw new IllegalStateException("Module finder is closed");
                }
                list.add(loader);
            }
            return loader;
        };
    }

    public LocalModuleFinder(File[] repoRoots, PathFilter pathFilter) {
        this(repoRoots, pathFilter, true);
    }

    public LocalModuleFinder(File[] repoRoots) {
        this(repoRoots, PathFilters.acceptAll());
    }

    public LocalModuleFinder() {
        this(true);
    }

    public LocalModuleFinder(boolean supportLayersAndAddOns) {
        this(LocalModuleFinder.getRepoRoots(supportLayersAndAddOns), PathFilters.acceptAll(), false);
    }

    static File[] getRepoRoots(boolean supportLayersAndAddOns) {
        return supportLayersAndAddOns ? LayeredModulePathFactory.resolveLayeredModulePath(LocalModuleFinder.getModulePathFiles()) : LocalModuleFinder.getModulePathFiles();
    }

    private static File[] getModulePathFiles() {
        return LocalModuleFinder.getFiles(System.getProperty("module.path", System.getenv("JAVA_MODULEPATH")), 0, 0);
    }

    private static File[] getFiles(String modulePath, int stringIdx, int arrayIdx) {
        File[] files;
        if (modulePath == null) {
            return NO_FILES;
        }
        int i = modulePath.indexOf(File.pathSeparatorChar, stringIdx);
        if (i == -1) {
            files = new File[arrayIdx + 1];
            files[arrayIdx] = new File(modulePath.substring(stringIdx)).getAbsoluteFile();
        } else {
            files = LocalModuleFinder.getFiles(modulePath, i + 1, arrayIdx + 1);
            files[arrayIdx] = new File(modulePath.substring(stringIdx, i)).getAbsoluteFile();
        }
        return files;
    }

    private static String toPathString(String moduleName) {
        return moduleName.replace('.', File.separatorChar);
    }

    private static String toLegacyPathString(String moduleName) {
        ModuleIdentifier moduleIdentifier = ModuleIdentifier.fromString(moduleName);
        String name = moduleIdentifier.getName();
        String slot = moduleIdentifier.getSlot();
        StringBuilder builder = new StringBuilder(name.length() + slot.length() + 2);
        builder.append(name.replace('.', File.separatorChar));
        builder.append(File.separatorChar).append(slot);
        return builder.toString();
    }

    @Override
    public ModuleSpec findModule(String name, ModuleLoader delegateLoader) throws ModuleLoadException {
        String child1 = LocalModuleFinder.toPathString(name);
        String child2 = LocalModuleFinder.toLegacyPathString(name);
        PathFilter pathFilter = this.pathFilter;
        if (pathFilter.accept(child1 + "/") || pathFilter.accept(child2 + "/")) {
            try {
                return AccessController.doPrivileged(() -> LocalModuleFinder.parseModuleXmlFile(this.resourceRootFactory, name, delegateLoader, this.repoRoots), this.accessControlContext);
            }
            catch (PrivilegedActionException e) {
                try {
                    throw e.getCause();
                }
                catch (IOException e1) {
                    throw new ModuleLoadException(e1);
                }
                catch (Error | RuntimeException | ModuleLoadException e1) {
                    throw e1;
                }
                catch (Throwable t) {
                    throw new UndeclaredThrowableException(t);
                }
            }
        }
        return null;
    }

    @Deprecated
    public static ModuleSpec parseModuleXmlFile(ModuleIdentifier identifier, ModuleLoader delegateLoader, File ... roots) throws IOException, ModuleLoadException {
        return LocalModuleFinder.parseModuleXmlFile(identifier.toString(), delegateLoader, roots);
    }

    public static ModuleSpec parseModuleXmlFile(String name, ModuleLoader delegateLoader, File ... roots) throws IOException, ModuleLoadException {
        return LocalModuleFinder.parseModuleXmlFile(ModuleXmlParser.ResourceRootFactory.getDefault(), name, delegateLoader, roots);
    }

    static ModuleSpec parseModuleXmlFile(ModuleXmlParser.ResourceRootFactory factory, String name, ModuleLoader delegateLoader, File ... roots) throws IOException, ModuleLoadException {
        String child1 = LocalModuleFinder.toPathString(name);
        String child2 = LocalModuleFinder.toLegacyPathString(name);
        for (File root : roots) {
            File file = new File(root, child1);
            File moduleXml = new File(file, "module.xml");
            if (!moduleXml.exists()) {
                file = new File(root, child2);
                moduleXml = new File(file, "module.xml");
            }
            if (!moduleXml.exists()) continue;
            ModuleSpec spec = ModuleXmlParser.parseModuleXml(factory, delegateLoader, name, file, moduleXml);
            if (spec == null) break;
            return spec;
        }
        return null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("local module finder @").append(Integer.toHexString(this.hashCode())).append(" (roots: ");
        int repoRootsLength = this.repoRoots.length;
        for (int i = 0; i < repoRootsLength; ++i) {
            File root = this.repoRoots[i];
            b.append(root);
            if (i == repoRootsLength - 1) continue;
            b.append(',');
        }
        b.append(')');
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<ResourceLoader> toClose;
        List<ResourceLoader> list = this.resourceLoaderList;
        List<ResourceLoader> list2 = list;
        synchronized (list2) {
            if (list.size() == 1 && list.get(0) == TERMINATED_MARKER) {
                return;
            }
            toClose = new ArrayList<ResourceLoader>(list);
            list.clear();
            list.add(TERMINATED_MARKER);
        }
        for (ResourceLoader resourceLoader : toClose) {
            LocalModuleFinder.safeClose(resourceLoader);
        }
    }

    private static void safeClose(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

