/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.lang.annotation.ElementType;
import java.util.HashMap;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.cfg.AnalyzerDefMapping;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.FieldBridgeDirectMapping;
import org.hibernate.search.cfg.FieldMapping;
import org.hibernate.search.cfg.NumericFieldMapping;
import org.hibernate.search.cfg.PropertyDescriptor;
import org.hibernate.search.cfg.PropertyMapping;
import org.hibernate.search.cfg.SearchMapping;

public class ContainedInMapping {
    private final SearchMapping mapping;
    private final PropertyDescriptor property;
    private final EntityDescriptor entity;

    public ContainedInMapping(SearchMapping mapping, PropertyDescriptor property, EntityDescriptor entity) {
        this.mapping = mapping;
        this.property = property;
        this.entity = entity;
        HashMap<String, Object> containedIn = new HashMap<String, Object>();
        property.setContainedIn(containedIn);
    }

    public FieldMapping field() {
        return new FieldMapping(this.property, this.entity, this.mapping);
    }

    @Deprecated
    public NumericFieldMapping numericField() {
        return new NumericFieldMapping(this.property.getName(), this.property, this.entity, this.mapping);
    }

    public PropertyMapping property(String name, ElementType type) {
        return new PropertyMapping(name, type, this.entity, this.mapping);
    }

    public AnalyzerDefMapping analyzerDef(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
        return new AnalyzerDefMapping(name, tokenizerFactory, this.mapping);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this.mapping);
    }

    public PropertyMapping bridge(Class<? extends FieldBridge> fieldBridge) {
        return new FieldBridgeDirectMapping(this.property, this.entity, this.mapping, fieldBridge);
    }
}

