/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.EnvUtil;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.connections.httpclient.HttpClientBuilder;
import org.keycloak.connections.httpclient.HttpClientFactory;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.connections.httpclient.ProxyMappings;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.truststore.TruststoreProvider;

public class DefaultHttpClientFactory
implements HttpClientFactory {
    private static final Logger logger = Logger.getLogger(DefaultHttpClientFactory.class);
    private volatile CloseableHttpClient httpClient;
    private Config.Scope config;

    public HttpClientProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new HttpClientProvider(){

            public HttpClient getHttpClient() {
                return DefaultHttpClientFactory.this.httpClient;
            }

            public void close() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int postText(String uri, String text) throws IOException {
                HttpPost request = new HttpPost(uri);
                request.setEntity(EntityBuilder.create().setText(text).setContentType(ContentType.TEXT_PLAIN).build());
                CloseableHttpResponse response = DefaultHttpClientFactory.this.httpClient.execute((HttpUriRequest)request);
                try {
                    int n = response.getStatusLine().getStatusCode();
                    return n;
                }
                finally {
                    InputStream is;
                    HttpEntity entity = response.getEntity();
                    if (entity != null && (is = entity.getContent()) != null) {
                        is.close();
                    }
                }
            }

            public InputStream get(String uri) throws IOException {
                HttpGet request = new HttpGet(uri);
                CloseableHttpResponse response = DefaultHttpClientFactory.this.httpClient.execute((HttpUriRequest)request);
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    return null;
                }
                return entity.getContent();
            }
        };
    }

    public void close() {
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getId() {
        return "default";
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.httpClient == null) {
            DefaultHttpClientFactory defaultHttpClientFactory = this;
            synchronized (defaultHttpClientFactory) {
                if (this.httpClient == null) {
                    boolean disableTrustManager;
                    long socketTimeout = this.config.getLong("socket-timeout-millis", Long.valueOf(-1L));
                    long establishConnectionTimeout = this.config.getLong("establish-connection-timeout-millis", Long.valueOf(-1L));
                    int maxPooledPerRoute = this.config.getInt("max-pooled-per-route", Integer.valueOf(64));
                    int connectionPoolSize = this.config.getInt("connection-pool-size", Integer.valueOf(128));
                    long connectionTTL = this.config.getLong("connection-ttl-millis", Long.valueOf(-1L));
                    long maxConnectionIdleTime = this.config.getLong("max-connection-idle-time-millis", Long.valueOf(900000L));
                    boolean disableCookies = this.config.getBoolean("disable-cookies", Boolean.valueOf(true));
                    String clientKeystore = this.config.get("client-keystore");
                    String clientKeystorePassword = this.config.get("client-keystore-password");
                    String clientPrivateKeyPassword = this.config.get("client-key-password");
                    String[] proxyMappings = this.config.getArray("proxy-mappings");
                    TruststoreProvider truststoreProvider = (TruststoreProvider)session.getProvider(TruststoreProvider.class);
                    boolean bl = disableTrustManager = truststoreProvider == null || truststoreProvider.getTruststore() == null;
                    if (disableTrustManager) {
                        logger.warn((Object)"Truststore is disabled");
                    }
                    HttpClientBuilder.HostnameVerificationPolicy hostnamePolicy = disableTrustManager ? null : HttpClientBuilder.HostnameVerificationPolicy.valueOf(truststoreProvider.getPolicy().name());
                    HttpClientBuilder builder = new HttpClientBuilder();
                    builder.socketTimeout(socketTimeout, TimeUnit.MILLISECONDS).establishConnectionTimeout(establishConnectionTimeout, TimeUnit.MILLISECONDS).maxPooledPerRoute(maxPooledPerRoute).connectionPoolSize(connectionPoolSize).connectionTTL(connectionTTL, TimeUnit.MILLISECONDS).maxConnectionIdleTime(maxConnectionIdleTime, TimeUnit.MILLISECONDS).disableCookies(disableCookies).proxyMappings(ProxyMappings.valueOf(proxyMappings));
                    if (!disableTrustManager) {
                        builder.hostnameVerification(hostnamePolicy);
                        try {
                            builder.trustStore(truststoreProvider.getTruststore());
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to load truststore", e);
                        }
                    }
                    if (clientKeystore != null) {
                        clientKeystore = EnvUtil.replace((String)clientKeystore);
                        try {
                            KeyStore clientCertKeystore = KeystoreUtil.loadKeyStore((String)clientKeystore, (String)clientKeystorePassword);
                            builder.keyStore(clientCertKeystore, clientPrivateKeyPassword);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to load keystore", e);
                        }
                    }
                    this.httpClient = builder.build();
                }
            }
        }
    }

    public void postInit(KeycloakSessionFactory factory) {
    }
}

