/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.context.Flag;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class BeginInvalidationCommand
extends InvalidateCommand {
    private Object lockOwner;

    public BeginInvalidationCommand() {
    }

    public BeginInvalidationCommand(CacheNotifier notifier, Set<Flag> flags, CommandInvocationId commandInvocationId, Object[] keys, Object lockOwner) {
        super(notifier, flags, commandInvocationId, keys);
        this.lockOwner = lockOwner;
    }

    public Object getLockOwner() {
        return this.lockOwner;
    }

    public void writeTo(ObjectOutput output) throws IOException {
        super.writeTo(output);
        output.writeObject(this.lockOwner);
    }

    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readFrom(input);
        this.lockOwner = input.readObject();
    }

    public byte getCommandId() {
        return 122;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof BeginInvalidationCommand) {
            BeginInvalidationCommand bic = (BeginInvalidationCommand)((Object)o);
            return Objects.equals(this.lockOwner, bic.lockOwner);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() + (this.lockOwner == null ? 0 : this.lockOwner.hashCode());
    }

    public String toString() {
        return "BeginInvalidateCommand{keys=" + Arrays.toString(this.keys) + ", sessionTransactionId=" + this.lockOwner + '}';
    }
}

