/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.logmanager;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.logging.resolvers.FileResolver;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.PropertyConfigurator;
import org.jboss.logmanager.config.ErrorManagerConfiguration;
import org.jboss.logmanager.config.FilterConfiguration;
import org.jboss.logmanager.config.FormatterConfiguration;
import org.jboss.logmanager.config.HandlerConfiguration;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.LoggerConfiguration;
import org.jboss.logmanager.config.PojoConfiguration;

public class ConfigurationPersistence
implements Configurator,
LogContextConfiguration {
    private static final Object LOCK = new Object();
    private static final String PROPERTIES_FILE = "logging.properties";
    private static final byte[] NOTE_MESSAGE = String.format("# Note this file has been generated and will be overwritten if a%n# logging subsystem has been defined in the XML configuration.%n%n", new Object[0]).getBytes(StandardCharsets.UTF_8);
    private final PropertyConfigurator config;
    private final LogContextConfiguration delegate;

    public ConfigurationPersistence() {
        this(LogContext.getSystemLogContext());
    }

    public ConfigurationPersistence(LogContext logContext) {
        this(new PropertyConfigurator(logContext));
    }

    public ConfigurationPersistence(PropertyConfigurator config) {
        this.config = config;
        this.delegate = config.getLogContextConfiguration();
    }

    public static ConfigurationPersistence getOrCreateConfigurationPersistence() {
        return ConfigurationPersistence.getOrCreateConfigurationPersistence(LogContext.getLogContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationPersistence getOrCreateConfigurationPersistence(LogContext logContext) {
        ConfigurationPersistence result;
        Logger root = logContext.getLogger("");
        Object object = LOCK;
        synchronized (object) {
            Configurator existing;
            Configurator configurator = (Configurator)root.getAttachment(Configurator.ATTACHMENT_KEY);
            if (configurator == null && (existing = (Configurator)root.attachIfAbsent(Configurator.ATTACHMENT_KEY, (Object)(configurator = new ConfigurationPersistence(logContext)))) != null) {
                configurator = existing;
            }
            if (configurator instanceof ConfigurationPersistence) {
                result = (ConfigurationPersistence)configurator;
            } else if (configurator instanceof PropertyConfigurator) {
                result = new ConfigurationPersistence((PropertyConfigurator)configurator);
                root.attach(Configurator.ATTACHMENT_KEY, (Object)result);
            } else {
                LoggingLogger.ROOT_LOGGER.replacingConfigurator(configurator);
                result = new ConfigurationPersistence(logContext);
                root.attach(Configurator.ATTACHMENT_KEY, (Object)result);
            }
        }
        return result;
    }

    public static ConfigurationPersistence getConfigurationPersistence(LogContext logContext) {
        if (logContext == null) {
            return null;
        }
        return (ConfigurationPersistence)logContext.getAttachment("", Configurator.ATTACHMENT_KEY);
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                LoggingLogger.ROOT_LOGGER.failedToCloseResource(t, closeable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(InputStream inputStream) throws IOException {
        Object object = LOCK;
        synchronized (object) {
            this.config.configure(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogContext getLogContext() {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.getLogContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerConfiguration addLoggerConfiguration(String loggerName) {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.addLoggerConfiguration(loggerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLoggerConfiguration(String loggerName) {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.removeLoggerConfiguration(loggerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerConfiguration getLoggerConfiguration(String loggerName) {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.getLoggerConfiguration(loggerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLoggerNames() {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.getLoggerNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlerConfiguration addHandlerConfiguration(String moduleName, String className, String handlerName, String ... constructorProperties) {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.addHandlerConfiguration(moduleName, className, handlerName, constructorProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHandlerConfiguration(String handlerName) {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.removeHandlerConfiguration(handlerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlerConfiguration getHandlerConfiguration(String handlerName) {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.getHandlerConfiguration(handlerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getHandlerNames() {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.getHandlerNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormatterConfiguration addFormatterConfiguration(String moduleName, String className, String formatterName, String ... constructorProperties) {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.addFormatterConfiguration(moduleName, className, formatterName, constructorProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFormatterConfiguration(String formatterName) {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.removeFormatterConfiguration(formatterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormatterConfiguration getFormatterConfiguration(String formatterName) {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.getFormatterConfiguration(formatterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFormatterNames() {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.getFormatterNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterConfiguration addFilterConfiguration(String moduleName, String className, String filterName, String ... constructorProperties) {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.addFilterConfiguration(moduleName, className, filterName, constructorProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFilterConfiguration(String filterName) {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.removeFilterConfiguration(filterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterConfiguration getFilterConfiguration(String filterName) {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.getFilterConfiguration(filterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFilterNames() {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.getFilterNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorManagerConfiguration addErrorManagerConfiguration(String moduleName, String className, String errorManagerName, String ... constructorProperties) {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.addErrorManagerConfiguration(moduleName, className, errorManagerName, constructorProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeErrorManagerConfiguration(String errorManagerName) {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.removeErrorManagerConfiguration(errorManagerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorManagerConfiguration getErrorManagerConfiguration(String errorManagerName) {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.getErrorManagerConfiguration(errorManagerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getErrorManagerNames() {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.getErrorManagerNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() {
        Object object = LOCK;
        synchronized (object) {
            this.delegate.prepare();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PojoConfiguration addPojoConfiguration(String moduleName, String className, String pojoName, String ... constructorProperties) {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.addPojoConfiguration(moduleName, className, pojoName, constructorProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePojoConfiguration(String pojoName) {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.removePojoConfiguration(pojoName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PojoConfiguration getPojoConfiguration(String pojoName) {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.getPojoConfiguration(pojoName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPojoNames() {
        Object object = LOCK;
        synchronized (object) {
            return this.delegate.getPojoNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Object object = LOCK;
        synchronized (object) {
            this.delegate.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget() {
        Object object = LOCK;
        synchronized (object) {
            this.delegate.forget();
        }
    }

    public void rollback() {
        this.forget();
    }

    public LogContextConfiguration getLogContextConfiguration() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConfiguration(OperationContext context) {
        String loggingConfig;
        switch (context.getProcessType()) {
            case DOMAIN_SERVER: {
                loggingConfig = FileResolver.resolvePath(context, "jboss.server.data.dir", PROPERTIES_FILE);
                break;
            }
            case STANDALONE_SERVER: {
                loggingConfig = FileResolver.resolvePath(context, "jboss.server.config.dir", PROPERTIES_FILE);
                break;
            }
            default: {
                return;
            }
        }
        if (loggingConfig == null) {
            LoggingLogger.ROOT_LOGGER.warn(LoggingLogger.ROOT_LOGGER.pathManagerServiceNotStarted());
        } else {
            File configFile = new File(loggingConfig);
            Object object = LOCK;
            synchronized (object) {
                try {
                    this.commit();
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(configFile);
                        FileLock lock = out.getChannel().lock();
                        try {
                            out.write(NOTE_MESSAGE);
                            this.config.writeConfiguration((OutputStream)out);
                        }
                        finally {
                            if (lock.isValid()) {
                                lock.release();
                            }
                        }
                        LoggingLogger.ROOT_LOGGER.tracef("Logging configuration file '%s' successfully written.", configFile.getAbsolutePath());
                    }
                    catch (IOException e) {
                        try {
                            throw LoggingLogger.ROOT_LOGGER.failedToWriteConfigurationFile(e, configFile);
                        }
                        catch (Throwable throwable) {
                            ConfigurationPersistence.safeClose(out);
                            throw throwable;
                        }
                    }
                    ConfigurationPersistence.safeClose(out);
                }
                finally {
                    this.forget();
                }
            }
        }
    }
}

