/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DecisionResultCollector;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.PermissionTicketToken;

public class PermissionTicketAwareDecisionResultCollector
extends DecisionResultCollector {
    private final AuthorizationRequest request;
    private PermissionTicketToken ticket;
    private final Identity identity;
    private ResourceServer resourceServer;
    private final AuthorizationProvider authorization;
    private List<Result> results;

    public PermissionTicketAwareDecisionResultCollector(AuthorizationRequest request, PermissionTicketToken ticket, Identity identity, ResourceServer resourceServer, AuthorizationProvider authorization) {
        this.request = request;
        this.ticket = ticket;
        this.identity = identity;
        this.resourceServer = resourceServer;
        this.authorization = authorization;
    }

    @Override
    protected void onDeny(Result result) {
        ResourcePermission permission = result.getPermission();
        Resource resource = permission.getResource();
        if (resource != null && resource.isOwnerManagedAccess() && !resource.getOwner().equals(this.identity.getId())) {
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("resource.id", resource.getId());
            filters.put("requester", this.identity.getId());
            filters.put("granted", Boolean.TRUE.toString());
            List<PermissionTicket> permissions = this.authorization.getStoreFactory().getPermissionTicketStore().find(filters, resource.getResourceServer().getId(), -1, -1);
            if (!permissions.isEmpty()) {
                ArrayList<Scope> grantedScopes = new ArrayList<Scope>();
                for (Result.PolicyResult policyResult : result.getResults()) {
                    for (PermissionTicket ticket : permissions) {
                        Scope grantedScope = ticket.getScope();
                        if ("resource".equals(policyResult.getPolicy().getType())) {
                            policyResult.setStatus(Decision.Effect.PERMIT);
                        }
                        if (grantedScope == null) continue;
                        grantedScopes.add(grantedScope);
                        for (Scope policyScope : policyResult.getPolicy().getScopes()) {
                            if (!policyScope.equals(grantedScope)) continue;
                            policyResult.setStatus(Decision.Effect.PERMIT);
                        }
                    }
                }
                permission.getScopes().clear();
                permission.getScopes().addAll(grantedScopes);
            }
        }
        super.onDeny(result);
    }

    @Override
    public void onComplete() {
        super.onComplete();
        if (this.request.isSubmitRequest()) {
            StoreFactory storeFactory = this.authorization.getStoreFactory();
            ResourceStore resourceStore = storeFactory.getResourceStore();
            if (this.ticket.getResources() != null) {
                for (PermissionTicketToken.ResourcePermission permission : this.ticket.getResources()) {
                    Resource resource = resourceStore.findById(permission.getResourceId(), this.resourceServer.getId());
                    if (resource == null) {
                        resource = resourceStore.findByName(permission.getResourceId(), this.identity.getId(), this.resourceServer.getId());
                    }
                    if (!resource.isOwnerManagedAccess() || resource.getOwner().equals(this.identity.getId()) || resource.getOwner().equals(this.resourceServer.getId())) continue;
                    Set scopes = permission.getScopes();
                    if (scopes.isEmpty()) {
                        scopes = resource.getScopes().stream().map(Scope::getName).collect(Collectors.toSet());
                    }
                    if (scopes.isEmpty()) {
                        HashMap<String, String> filters = new HashMap<String, String>();
                        filters.put("resource.id", resource.getId());
                        filters.put("requester", this.identity.getId());
                        filters.put("scope_is_null", Boolean.TRUE.toString());
                        List<PermissionTicket> permissions = this.authorization.getStoreFactory().getPermissionTicketStore().find(filters, resource.getResourceServer().getId(), -1, -1);
                        if (!permissions.isEmpty()) continue;
                        this.authorization.getStoreFactory().getPermissionTicketStore().create(resource.getId(), null, this.identity.getId(), resource.getResourceServer());
                        continue;
                    }
                    ScopeStore scopeStore = this.authorization.getStoreFactory().getScopeStore();
                    for (String scopeId : scopes) {
                        Scope scope = scopeStore.findByName(scopeId, this.resourceServer.getId());
                        if (scope == null) {
                            scope = scopeStore.findById(scopeId, this.resourceServer.getId());
                        }
                        HashMap<String, String> filters = new HashMap<String, String>();
                        filters.put("resource.id", resource.getId());
                        filters.put("requester", this.identity.getId());
                        filters.put("scope.id", scope.getId());
                        List<PermissionTicket> permissions = this.authorization.getStoreFactory().getPermissionTicketStore().find(filters, resource.getResourceServer().getId(), -1, -1);
                        if (!permissions.isEmpty()) continue;
                        this.authorization.getStoreFactory().getPermissionTicketStore().create(resource.getId(), scope.getId(), this.identity.getId(), resource.getResourceServer());
                    }
                }
            }
        }
    }

    @Override
    protected void onComplete(List<Result> results) {
        this.results = results;
    }

    public List<Result> results() {
        return this.results;
    }
}

