/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.XAJMSContext;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicSession;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionForContext;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionForContextImpl;
import org.apache.activemq.artemis.ra.ActiveMQRABundle;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionManager;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionRequestInfo;
import org.apache.activemq.artemis.ra.ActiveMQRAJMSContext;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRASession;
import org.apache.activemq.artemis.ra.ActiveMQRASessionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAXAJMSContext;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;

public final class ActiveMQRASessionFactoryImpl
extends ActiveMQConnectionForContextImpl
implements ActiveMQRASessionFactory,
ActiveMQConnectionForContext,
Referenceable {
    private static boolean trace = ActiveMQRALogger.LOGGER.isTraceEnabled();
    private boolean closed = false;
    private Reference reference;
    private String userName;
    private String password;
    private String clientID;
    private final int type;
    private boolean started = false;
    private final ActiveMQRAManagedConnectionFactory mcf;
    private TransactionManager tm;
    private ConnectionManager cm;
    private final Set<ActiveMQRASession> sessions = new HashSet<ActiveMQRASession>();
    private final Set<TemporaryQueue> tempQueues = new HashSet<TemporaryQueue>();
    private final Set<TemporaryTopic> tempTopics = new HashSet<TemporaryTopic>();
    private boolean allowLocalTransaction;

    public ActiveMQRASessionFactoryImpl(ActiveMQRAManagedConnectionFactory mcf, ConnectionManager cm, TransactionManager tm, int type) {
        this.mcf = mcf;
        this.tm = tm;
        this.cm = cm == null ? new ActiveMQRAConnectionManager() : cm;
        this.type = type;
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("constructor(" + mcf + ", " + cm + ", " + type);
        }
    }

    public JMSContext createContext(int sessionMode) {
        int sessionModeToUse;
        boolean inJtaTx = this.inJtaTransaction();
        switch (sessionMode) {
            case 1: 
            case 3: 
            case 100: 
            case 101: {
                sessionModeToUse = sessionMode;
                break;
            }
            case 2: {
                if (!inJtaTx) {
                    throw ActiveMQRABundle.BUNDLE.invalidSessionTransactedModeRuntime();
                }
                sessionModeToUse = 1;
                break;
            }
            case 0: {
                if (!inJtaTx) {
                    throw ActiveMQRABundle.BUNDLE.invalidClientAcknowledgeModeRuntime();
                }
                sessionModeToUse = 1;
                break;
            }
            default: {
                throw ActiveMQRABundle.BUNDLE.invalidAcknowledgeMode(sessionMode);
            }
        }
        this.incrementRefCounter();
        return new ActiveMQRAJMSContext(this, sessionModeToUse, this.threadAwareContext);
    }

    public XAJMSContext createXAContext() {
        this.incrementRefCounter();
        return new ActiveMQRAXAJMSContext(this, this.threadAwareContext);
    }

    public void setReference(Reference reference) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setReference(" + reference + ")");
        }
        this.reference = reference;
    }

    public Reference getReference() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getReference()");
        }
        return this.reference;
    }

    public void setUserName(String name) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setUserName(" + name + ")");
        }
        this.userName = name;
    }

    public void setPassword(String password) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setPassword(****)");
        }
        this.password = password;
    }

    public String getClientID() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getClientID()");
        }
        this.checkClosed();
        if (this.clientID == null) {
            return ((ActiveMQResourceAdapter)this.mcf.getResourceAdapter()).getProperties().getClientID();
        }
        return this.clientID;
    }

    public void setClientID(String cID) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setClientID(" + cID + ")");
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createQueueSession(" + transacted + ", " + acknowledgeMode + ")");
        }
        this.checkClosed();
        if (this.type == 2 || this.type == 5) {
            throw new IllegalStateException("Can not get a queue session from a topic connection");
        }
        return this.allocateConnection(transacted, acknowledgeMode, this.type);
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createXAQueueSession()");
        }
        this.checkClosed();
        if (this.type == 0 || this.type == 2 || this.type == 5) {
            throw new IllegalStateException("Can not get a topic session from a queue connection");
        }
        return this.allocateConnection(this.type);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createConnectionConsumer(" + queue + ", " + messageSelector + ", " + sessionPool + ", " + maxMessages + ")");
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createTopicSession(" + transacted + ", " + acknowledgeMode + ")");
        }
        this.checkClosed();
        if (this.type == 1 || this.type == 4) {
            throw new IllegalStateException("Can not get a topic session from a queue connection");
        }
        return this.allocateConnection(transacted, acknowledgeMode, this.type);
    }

    public XATopicSession createXATopicSession() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createXATopicSession()");
        }
        this.checkClosed();
        if (this.type == 0 || this.type == 1 || this.type == 4) {
            throw new IllegalStateException("Can not get a topic session from a queue connection");
        }
        return this.allocateConnection(this.type);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createConnectionConsumer(" + topic + ", " + messageSelector + ", " + sessionPool + ", " + maxMessages + ")");
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createConnectionConsumer(" + topic + ", " + subscriptionName + ", " + messageSelector + ", " + sessionPool + ", " + maxMessages + ")");
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, ServerSessionPool pool, int maxMessages) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createConnectionConsumer(" + destination + ", " + pool + ", " + maxMessages + ")");
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String name, ServerSessionPool pool, int maxMessages) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createConnectionConsumer(" + destination + ", " + name + ", " + pool + ", " + maxMessages + ")");
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createSession(" + transacted + ", " + acknowledgeMode + ")");
        }
        this.checkClosed();
        return this.allocateConnection(transacted, acknowledgeMode, this.type);
    }

    public XASession createXASession() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createXASession()");
        }
        this.checkClosed();
        return this.allocateConnection(this.type);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getMetaData()");
        }
        this.checkClosed();
        return this.mcf.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getExceptionListener()");
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setExceptionListener(" + listener + ")");
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        this.checkClosed();
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("start() " + this);
        }
        Set<ActiveMQRASession> set = this.sessions;
        synchronized (set) {
            if (this.started) {
                return;
            }
            this.started = true;
            for (ActiveMQRASession session : this.sessions) {
                session.start();
            }
        }
    }

    public void stop() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("stop() " + this);
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        TemporaryQueue temp;
        Iterator<ActiveMQRASession> i;
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("close() " + this);
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        Set<ActiveMQRASession> set = this.sessions;
        synchronized (set) {
            i = this.sessions.iterator();
            while (i.hasNext()) {
                ActiveMQRASession session = i.next();
                try {
                    session.closeSession();
                }
                catch (Throwable t) {
                    ActiveMQRALogger.LOGGER.trace("Error closing session", t);
                }
                i.remove();
            }
        }
        set = this.tempQueues;
        synchronized (set) {
            i = this.tempQueues.iterator();
            while (i.hasNext()) {
                temp = (TemporaryQueue)i.next();
                try {
                    if (trace) {
                        ActiveMQRALogger.LOGGER.trace("Closing temporary queue " + temp + " for " + this);
                    }
                    temp.delete();
                }
                catch (Throwable t) {
                    ActiveMQRALogger.LOGGER.trace("Error deleting temporary queue", t);
                }
                i.remove();
            }
        }
        set = this.tempTopics;
        synchronized (set) {
            i = this.tempTopics.iterator();
            while (i.hasNext()) {
                temp = (TemporaryTopic)i.next();
                try {
                    if (trace) {
                        ActiveMQRALogger.LOGGER.trace("Closing temporary topic " + temp + " for " + this);
                    }
                    temp.delete();
                }
                catch (Throwable t) {
                    ActiveMQRALogger.LOGGER.trace("Error deleting temporary queue", t);
                }
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSession(ActiveMQRASession session) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("closeSession(" + session + ")");
        }
        Set<ActiveMQRASession> set = this.sessions;
        synchronized (set) {
            this.sessions.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTemporaryQueue(TemporaryQueue temp) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("addTemporaryQueue(" + temp + ")");
        }
        Set<TemporaryQueue> set = this.tempQueues;
        synchronized (set) {
            this.tempQueues.add(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTemporaryTopic(TemporaryTopic temp) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("addTemporaryTopic(" + temp + ")");
        }
        Set<TemporaryTopic> set = this.tempTopics;
        synchronized (set) {
            this.tempTopics.add(temp);
        }
    }

    public Session createSession(int sessionMode) throws JMSException {
        return this.createSession(sessionMode == 0, sessionMode);
    }

    public Session createSession() throws JMSException {
        return this.createSession(1);
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createSharedConnectionConsumer(" + topic + ", " + subscriptionName + ", " + messageSelector + ", " + sessionPool + ", " + maxMessages + ")");
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createSharedDurableConnectionConsumer(" + topic + ", " + subscriptionName + ", " + messageSelector + ", " + sessionPool + ", " + maxMessages + ")");
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    protected ActiveMQRASession allocateConnection(int sessionType) throws JMSException {
        return this.allocateConnection(false, 1, sessionType);
    }

    protected ActiveMQRASession allocateConnection(boolean transacted, int acknowledgeMode, int sessionType) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("allocateConnection(" + transacted + ", " + acknowledgeMode + ", " + sessionType + ")");
        }
        try {
            Set<ActiveMQRASession> set = this.sessions;
            synchronized (set) {
                if (!this.sessions.isEmpty()) {
                    throw new IllegalStateException("Only allowed one session per connection. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
                }
                if (this.inJtaTransaction()) {
                    transacted = true;
                    acknowledgeMode = 0;
                } else if (transacted && this.mcf.isAllowLocalTransactions().booleanValue()) {
                    acknowledgeMode = 0;
                } else {
                    transacted = false;
                    switch (acknowledgeMode) {
                        case 1: 
                        case 3: 
                        case 100: 
                        case 101: {
                            break;
                        }
                        case 2: {
                            throw ActiveMQRABundle.BUNDLE.invalidClientAcknowledgeModeRuntime();
                        }
                        case 0: {
                            if (!this.mcf.isAllowLocalTransactions().booleanValue()) {
                                throw ActiveMQRABundle.BUNDLE.invalidSessionTransactedModeRuntimeAllowLocal();
                            }
                            transacted = true;
                            break;
                        }
                        default: {
                            throw ActiveMQRABundle.BUNDLE.invalidAcknowledgeMode(acknowledgeMode);
                        }
                    }
                }
                ActiveMQRAConnectionRequestInfo info = new ActiveMQRAConnectionRequestInfo(transacted, acknowledgeMode, sessionType);
                info.setUserName(this.userName);
                info.setPassword(this.password);
                info.setClientID(this.clientID);
                info.setDefaults(((ActiveMQResourceAdapter)this.mcf.getResourceAdapter()).getProperties());
                if (trace) {
                    ActiveMQRALogger.LOGGER.trace("Allocating session for " + this + " with request info=" + info);
                }
                ActiveMQRASession session = (ActiveMQRASession)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)info);
                try {
                    if (trace) {
                        ActiveMQRALogger.LOGGER.trace("Allocated  " + this + " session=" + session);
                    }
                    session.setActiveMQSessionFactory(this);
                    if (this.started) {
                        session.start();
                    }
                    this.sessions.add(session);
                    return session;
                }
                catch (Throwable t) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (t instanceof Exception) {
                        throw (Exception)t;
                    }
                    throw new RuntimeException("Unexpected error: ", t);
                }
            }
        }
        catch (Exception e) {
            Throwable current;
            for (current = e; current != null && !(current instanceof JMSException); current = current.getCause()) {
            }
            if (current != null && current instanceof JMSException) {
                throw (JMSException)current;
            }
            JMSException je = new JMSException("Could not create a session: " + e.getMessage());
            je.setLinkedException(e);
            je.initCause((Throwable)e);
            throw je;
        }
    }

    protected void checkClosed() throws IllegalStateException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("checkClosed()" + this);
        }
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
    }

    private boolean inJtaTransaction() {
        boolean inJtaTx = false;
        if (this.tm != null) {
            Transaction tx = null;
            try {
                tx = this.tm.getTransaction();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
            inJtaTx = tx != null;
        }
        return inJtaTx;
    }
}

