/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentResourceHandlerBase;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.ManagementUtil;
import org.jboss.as.domain.management.security.SecurityRealmAddHandler;
import org.jboss.as.domain.management.security.SecurityRealmRemoveHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

abstract class SecurityRealmParentRestartHandler
extends RestartParentResourceHandlerBase {
    static final Set<RuntimeCapability> NULL_CAPABILITIES = Collections.emptySet();
    protected final Set<RuntimeCapability> capabilities;

    SecurityRealmParentRestartHandler(RuntimeCapability ... capabilities) {
        super("security-realm");
        this.capabilities = capabilities == null || capabilities.length == 0 ? NULL_CAPABILITIES : Arrays.stream(capabilities).collect(Collectors.toSet());
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected boolean isResourceServiceRestartAllowed(OperationContext context, ServiceController<?> service) {
        return !ManagementUtil.isSecurityRealmReloadRequired(context, service);
    }

    protected void removeServices(OperationContext context, ServiceName parentService, ModelNode parentModel) throws OperationFailedException {
        SecurityRealmRemoveHandler.INSTANCE.removeServices(context, parentService.getSimpleName(), parentModel);
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
        SecurityRealmAddHandler.INSTANCE.installServices(context, parentAddress.getLastElement().getValue(), parentModel);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        String realmName = parentAddress.getLastElement().getValue();
        return SecurityRealm.ServiceUtil.createServiceName(realmName);
    }
}

