/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.NoopOperationStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.txn.subsystem.LogStoreAddHandler;
import org.jboss.as.txn.subsystem.LogStoreConstants;
import org.jboss.as.txn.subsystem.LogStoreProbeHandler;
import org.jboss.as.txn.subsystem.LogStoreResource;
import org.jboss.as.txn.subsystem.TransactionExtension;
import org.jboss.dmr.ModelNode;

public class LogStoreDefinition
extends SimpleResourceDefinition {
    private final boolean registerRuntimeOnly;

    public LogStoreDefinition(LogStoreResource resource, boolean registerRuntimeOnly) {
        super(TransactionExtension.LOG_STORE_PATH, (ResourceDescriptionResolver)TransactionExtension.getResourceDescriptionResolver("log-store"), (OperationStepHandler)new LogStoreAddHandler(resource), (OperationStepHandler)NoopOperationStepHandler.WITH_RESULT, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_NONE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        SimpleOperationDefinition probe = new SimpleOperationDefinitionBuilder("probe", this.getResourceDescriptionResolver()).withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY).setRuntimeOnly().setReadOnly().build();
        resourceRegistration.registerOperationHandler((OperationDefinition)probe, (OperationStepHandler)LogStoreProbeHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)LogStoreConstants.LOG_STORE_TYPE, null);
        if (this.registerRuntimeOnly) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)LogStoreConstants.EXPOSE_ALL_LOGS, null, (OperationStepHandler)new ExposeAllLogsWriteAttributeHandler());
        }
    }

    static class ExposeAllLogsWriteAttributeHandler
    extends AbstractRuntimeOnlyHandler {
        ExposeAllLogsWriteAttributeHandler() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            String attributeName = operation.require("name").asString();
            ModelNode newValue = operation.hasDefined("value") ? operation.get("value") : LogStoreConstants.EXPOSE_ALL_LOGS.getDefaultValue();
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            ModelNode submodel = resource.getModel();
            ModelNode syntheticOp = new ModelNode();
            syntheticOp.get(attributeName).set(newValue);
            LogStoreConstants.EXPOSE_ALL_LOGS.validateAndSet(syntheticOp, submodel);
            context.getResult().set(new ModelNode());
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }
    }
}

