/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.Constants;
import com.microsoft.azure.storage.DoesServiceRequest;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.blob.BlobEncryptStream;
import com.microsoft.azure.storage.blob.BlobOutputStream;
import com.microsoft.azure.storage.blob.BlobOutputStreamInternal;
import com.microsoft.azure.storage.blob.BlobRequest;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.BlobType;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.core.ExecutionEngine;
import com.microsoft.azure.storage.core.StorageRequest;
import com.microsoft.azure.storage.core.StreamMd5AndLength;
import com.microsoft.azure.storage.core.Utility;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import javax.crypto.Cipher;

public final class CloudAppendBlob
extends CloudBlob {
    public CloudAppendBlob(URI blobAbsoluteUri) throws StorageException {
        this(new StorageUri(blobAbsoluteUri));
    }

    public CloudAppendBlob(StorageUri blobAbsoluteUri) throws StorageException {
        this(blobAbsoluteUri, (StorageCredentials)null);
    }

    public CloudAppendBlob(CloudAppendBlob otherBlob) {
        super(otherBlob);
    }

    public CloudAppendBlob(URI blobAbsoluteUri, StorageCredentials credentials) throws StorageException {
        this(new StorageUri(blobAbsoluteUri), credentials);
    }

    public CloudAppendBlob(URI blobAbsoluteUri, String snapshotID, StorageCredentials credentials) throws StorageException {
        this(new StorageUri(blobAbsoluteUri), snapshotID, credentials);
    }

    public CloudAppendBlob(StorageUri blobAbsoluteUri, StorageCredentials credentials) throws StorageException {
        this(blobAbsoluteUri, null, credentials);
    }

    public CloudAppendBlob(StorageUri blobAbsoluteUri, String snapshotID, StorageCredentials credentials) throws StorageException {
        super(BlobType.APPEND_BLOB, blobAbsoluteUri, snapshotID, credentials);
    }

    protected CloudAppendBlob(String blobName, String snapshotID, CloudBlobContainer container) throws URISyntaxException {
        super(BlobType.APPEND_BLOB, blobName, snapshotID, container);
    }

    @DoesServiceRequest
    public final String startCopy(CloudAppendBlob sourceBlob) throws StorageException, URISyntaxException {
        return this.startCopy(sourceBlob, null, null, null, null);
    }

    @DoesServiceRequest
    public final String startCopy(CloudAppendBlob sourceBlob, AccessCondition sourceAccessCondition, AccessCondition destinationAccessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        Utility.assertNotNull("sourceBlob", sourceBlob);
        URI source = sourceBlob.getSnapshotQualifiedUri();
        if (sourceBlob.getServiceClient() != null && sourceBlob.getServiceClient().getCredentials() != null) {
            source = sourceBlob.getServiceClient().getCredentials().transformUri(sourceBlob.getSnapshotQualifiedUri());
        }
        return this.startCopy(source, sourceAccessCondition, destinationAccessCondition, options, opContext);
    }

    @DoesServiceRequest
    public void createOrReplace() throws StorageException {
        this.createOrReplace(null, null, null);
    }

    @DoesServiceRequest
    public void createOrReplace(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.APPEND_BLOB, this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.createImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> createImpl(final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.putBlob(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, blob.properties, BlobType.APPEND_BLOB, 0L);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudBlob blob, OperationContext context) {
                BlobRequest.addMetadata(connection, blob.metadata, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Void preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                this.getResult().setRequestServiceEncrypted(CloudBlob.isServerRequestEncrypted(this.getConnection()));
                blob.getProperties().setLength(0L);
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public Long appendBlock(InputStream sourceStream, long length) throws IOException, StorageException {
        return this.appendBlock(sourceStream, length, null, null, null);
    }

    @DoesServiceRequest
    public Long appendBlock(InputStream sourceStream, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        if (length < -1L) {
            throw new IllegalArgumentException("Invalid stream length, specify -1 for unknown length stream, or a positive number of bytes.");
        }
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.APPEND_BLOB, this.blobServiceClient);
        options.assertNoEncryptionPolicyOrStrictMode();
        if (sourceStream.markSupported()) {
            sourceStream.mark(0x10000000);
        }
        InputStream bufferedStreamReference = sourceStream;
        StreamMd5AndLength descriptor = new StreamMd5AndLength();
        descriptor.setLength(length);
        if (!sourceStream.markSupported()) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            descriptor = Utility.writeToOutputStream(sourceStream, byteStream, length, false, options.getUseTransactionalContentMD5(), opContext, options);
            bufferedStreamReference = new ByteArrayInputStream(byteStream.toByteArray());
        } else if (length < 0L || options.getUseTransactionalContentMD5().booleanValue()) {
            descriptor = Utility.analyzeStream(sourceStream, length, -1L, true, options.getUseTransactionalContentMD5());
        }
        if (descriptor.getLength() > 0x400000L) {
            throw new IllegalArgumentException("Invalid stream length, length must be less than or equal to 4 MB in size.");
        }
        StorageRequest<CloudBlobClient, CloudAppendBlob, Long> appendBlockImpl = this.appendBlockImpl(descriptor.getMd5(), bufferedStreamReference, descriptor.getLength(), accessCondition, options, opContext);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, appendBlockImpl, options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudAppendBlob, Long> appendBlockImpl(final String md5, final InputStream sourceStream, final long length, final AccessCondition accessCondition, final BlobRequestOptions options, final OperationContext opContext) {
        StorageRequest<CloudBlobClient, CloudAppendBlob, Long> putRequest = new StorageRequest<CloudBlobClient, CloudAppendBlob, Long>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudAppendBlob blob, OperationContext context) throws Exception {
                this.setSendStream(sourceStream);
                this.setLength(length);
                return BlobRequest.appendBlock(blob.getTransformedAddress(opContext).getUri(this.getCurrentLocation()), options, opContext, accessCondition);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudAppendBlob blob, OperationContext context) {
                if (options.getUseTransactionalContentMD5().booleanValue()) {
                    connection.setRequestProperty("Content-MD5", md5);
                }
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, length, context);
            }

            @Override
            public Long preProcessResponse(CloudAppendBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                Long appendOffset = null;
                if (this.getConnection().getHeaderField("x-ms-blob-append-offset") != null) {
                    appendOffset = Long.parseLong(this.getConnection().getHeaderField("x-ms-blob-append-offset"));
                }
                blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                blob.updateCommittedBlockCountFromResponse(this.getConnection());
                this.getResult().setRequestServiceEncrypted(CloudBlob.isServerRequestEncrypted(this.getConnection()));
                return appendOffset;
            }

            @Override
            public void recoveryAction(OperationContext context) throws IOException {
                sourceStream.reset();
                sourceStream.mark(0x10000000);
            }
        };
        return putRequest;
    }

    private void updateCommittedBlockCountFromResponse(HttpURLConnection request) {
        String comittedBlockCount = request.getHeaderField("x-ms-blob-committed-block-count");
        if (!Utility.isNullOrEmpty(comittedBlockCount)) {
            this.getProperties().setAppendBlobCommittedBlockCount(Integer.parseInt(comittedBlockCount));
        }
    }

    @DoesServiceRequest
    public void append(InputStream sourceStream, long length) throws StorageException, IOException {
        this.append(sourceStream, length, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoesServiceRequest
    public void append(InputStream sourceStream, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.APPEND_BLOB, this.blobServiceClient);
        if (sourceStream.markSupported()) {
            sourceStream.mark(0x10000000);
        }
        BlobOutputStream streamRef = this.openWriteExisting(accessCondition, options, opContext);
        try {
            streamRef.write(sourceStream, length);
        }
        finally {
            streamRef.close();
        }
    }

    public void appendFromByteArray(byte[] buffer, int offset, int length) throws StorageException, IOException {
        this.appendFromByteArray(buffer, offset, length, null, null, null);
    }

    public void appendFromByteArray(byte[] buffer, int offset, int length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, offset, length);
        this.append(inputStream, length, accessCondition, options, opContext);
        inputStream.close();
    }

    public void appendFromFile(String path) throws StorageException, IOException {
        this.appendFromFile(path, null, null, null);
    }

    public void appendFromFile(String path, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        File file = new File(path);
        long fileLength = file.length();
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        this.append(inputStream, fileLength, accessCondition, options, opContext);
        ((InputStream)inputStream).close();
    }

    public void appendText(String content) throws StorageException, IOException {
        this.appendText(content, null, null, null, null);
    }

    public void appendText(String content, String charsetName, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        byte[] bytes = charsetName == null ? content.getBytes() : content.getBytes(charsetName);
        this.appendFromByteArray(bytes, 0, bytes.length, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    public BlobOutputStream openWriteExisting() throws StorageException {
        return this.openWriteExisting(null, null, null);
    }

    @DoesServiceRequest
    public BlobOutputStream openWriteExisting(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        return this.openOutputStreamInternal(false, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    public BlobOutputStream openWriteNew() throws StorageException {
        return this.openWriteNew(null, null, null);
    }

    @DoesServiceRequest
    public BlobOutputStream openWriteNew(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        return this.openOutputStreamInternal(true, accessCondition, options, opContext);
    }

    private BlobOutputStream openOutputStreamInternal(boolean create, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.APPEND_BLOB, this.blobServiceClient, false);
        options.assertPolicyIfRequired();
        Cipher cipher = null;
        if (options.getEncryptionPolicy() != null) {
            cipher = options.getEncryptionPolicy().createAndSetEncryptionContext(this.getMetadata(), false);
        }
        if (create) {
            this.createOrReplace(accessCondition, options, opContext);
        } else {
            if (options.getStoreBlobContentMD5().booleanValue()) {
                throw new IllegalArgumentException("MD5 cannot be calculated for an existing append blob because it would require reading the existing data. Please disable StoreFileContentMD5.");
            }
            if (options.getEncryptionPolicy() != null) {
                throw new IllegalArgumentException("Encryption is not supported for a blob that already exists. Please do not specify an encryption policy.");
            }
            this.downloadAttributes(accessCondition, options, opContext);
        }
        AccessCondition appendCondition = new AccessCondition();
        if (accessCondition != null) {
            appendCondition.setLeaseID(accessCondition.getLeaseID());
            appendCondition.setIfAppendPositionEqual(accessCondition.getIfAppendPositionEqual());
            appendCondition.setIfMaxSizeLessThanOrEqual(accessCondition.getIfMaxSizeLessThanOrEqual());
        }
        if (options.getEncryptionPolicy() != null) {
            return new BlobEncryptStream(this, appendCondition, options, opContext, cipher);
        }
        return new BlobOutputStreamInternal(this, appendCondition, options, opContext);
    }

    @Override
    @DoesServiceRequest
    public void upload(InputStream sourceStream, long length) throws StorageException, IOException {
        this.upload(sourceStream, length, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DoesServiceRequest
    public void upload(InputStream sourceStream, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.APPEND_BLOB, this.blobServiceClient);
        if (sourceStream.markSupported()) {
            sourceStream.mark(0x10000000);
        }
        BlobOutputStream streamRef = this.openWriteNew(accessCondition, options, opContext);
        try {
            streamRef.write(sourceStream, length);
        }
        finally {
            streamRef.close();
        }
    }

    @Override
    public void setStreamWriteSizeInBytes(int streamWriteSizeInBytes) {
        if (streamWriteSizeInBytes > Constants.MAX_APPEND_BLOCK_SIZE || streamWriteSizeInBytes < 16384) {
            throw new IllegalArgumentException("StreamWriteSizeInBytes");
        }
        this.streamWriteSizeInBytes = streamWriteSizeInBytes;
    }
}

