/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.events;

import java.util.Set;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheManager;
import org.keycloak.models.cache.infinispan.authorization.events.AuthorizationCacheInvalidationEvent;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;

public class PermissionTicketRemovedEvent
extends InvalidationEvent
implements AuthorizationCacheInvalidationEvent {
    private String id;
    private String owner;
    private String resource;
    private String scope;
    private String serverId;

    public static PermissionTicketRemovedEvent create(String id, String owner, String resource, String scope, String serverId) {
        PermissionTicketRemovedEvent event = new PermissionTicketRemovedEvent();
        event.id = id;
        event.owner = owner;
        event.resource = resource;
        event.scope = scope;
        event.serverId = serverId;
        return event;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return String.format("PermissionTicketRemovedEvent [ id=%s, name=%s]", this.id, this.resource);
    }

    @Override
    public void addInvalidations(StoreFactoryCacheManager cache, Set<String> invalidations) {
        cache.permissionTicketRemoval(this.id, this.owner, this.resource, this.scope, this.serverId, invalidations);
    }
}

