/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheManager;
import org.keycloak.models.cache.infinispan.authorization.events.AuthorizationCacheInvalidationEvent;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.sessions.infinispan.util.KeycloakMarshallUtil;

@SerializeWith(value=ExternalizerImpl.class)
public class ResourceUpdatedEvent
extends InvalidationEvent
implements AuthorizationCacheInvalidationEvent {
    private String id;
    private String name;
    private String serverId;
    private String type;
    private String uri;
    private Set<String> scopes;
    private String owner;

    public static ResourceUpdatedEvent create(String id, String name, String type, String uri, Set<String> scopes, String serverId, String owner) {
        ResourceUpdatedEvent event = new ResourceUpdatedEvent();
        event.id = id;
        event.name = name;
        event.type = type;
        event.uri = uri;
        event.scopes = scopes;
        event.serverId = serverId;
        event.owner = owner;
        return event;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return String.format("ResourceUpdatedEvent [ id=%s, name=%s ]", this.id, this.name);
    }

    @Override
    public void addInvalidations(StoreFactoryCacheManager cache, Set<String> invalidations) {
        cache.resourceUpdated(this.id, this.name, this.type, this.uri, this.scopes, this.serverId, this.owner, invalidations);
    }

    public static class ExternalizerImpl
    implements Externalizer<ResourceUpdatedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, ResourceUpdatedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.id, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.name, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.type, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.uri, (ObjectOutput)output);
            KeycloakMarshallUtil.writeCollection(obj.scopes, KeycloakMarshallUtil.STRING_EXT, output);
            MarshallUtil.marshallString((String)obj.serverId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.owner, (ObjectOutput)output);
        }

        public ResourceUpdatedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public ResourceUpdatedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            ResourceUpdatedEvent res = new ResourceUpdatedEvent();
            res.id = MarshallUtil.unmarshallString((ObjectInput)input);
            res.name = MarshallUtil.unmarshallString((ObjectInput)input);
            res.type = MarshallUtil.unmarshallString((ObjectInput)input);
            res.uri = MarshallUtil.unmarshallString((ObjectInput)input);
            res.scopes = (Set)KeycloakMarshallUtil.readCollection(input, KeycloakMarshallUtil.STRING_EXT, HashSet::new);
            res.serverId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.owner = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

