/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.sessions.infinispan.InfinispanStickySessionEncoderProvider;
import org.keycloak.models.sessions.infinispan.util.InfinispanUtil;
import org.keycloak.sessions.StickySessionEncoderProvider;
import org.keycloak.sessions.StickySessionEncoderProviderFactory;

public class InfinispanStickySessionEncoderProviderFactory
implements StickySessionEncoderProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanStickySessionEncoderProviderFactory.class);
    private boolean shouldAttachRoute;

    public StickySessionEncoderProvider create(KeycloakSession session) {
        String myNodeName = InfinispanUtil.getMyAddress(session);
        if (myNodeName != null && myNodeName.startsWith("node_")) {
            myNodeName = null;
        }
        return new InfinispanStickySessionEncoderProvider(session, myNodeName, this.shouldAttachRoute);
    }

    public void init(Config.Scope config) {
        this.shouldAttachRoute = config.getBoolean("shouldAttachRoute", Boolean.valueOf(true));
        log.debugf("Should attach route to the sticky session cookie: %b", (Object)this.shouldAttachRoute);
    }

    public void setShouldAttachRoute(boolean shouldAttachRoute) {
        this.shouldAttachRoute = shouldAttachRoute;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }
}

