/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import org.keycloak.authorization.jpa.entities.PolicyEntity;
import org.keycloak.authorization.jpa.entities.ResourceEntity;
import org.keycloak.authorization.jpa.entities.ScopeEntity;
import org.keycloak.authorization.jpa.store.ResourceAdapter;
import org.keycloak.authorization.jpa.store.ScopeAdapter;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.jpa.JpaModel;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;

public class PolicyAdapter
implements Policy,
JpaModel<PolicyEntity> {
    private PolicyEntity entity;
    private EntityManager em;
    private StoreFactory storeFactory;

    public PolicyAdapter(PolicyEntity entity, EntityManager em, StoreFactory storeFactory) {
        this.entity = entity;
        this.em = em;
        this.storeFactory = storeFactory;
    }

    @Override
    public PolicyEntity getEntity() {
        return this.entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public String getType() {
        return this.entity.getType();
    }

    public DecisionStrategy getDecisionStrategy() {
        return this.entity.getDecisionStrategy();
    }

    public void setDecisionStrategy(DecisionStrategy decisionStrategy) {
        this.entity.setDecisionStrategy(decisionStrategy);
    }

    public Logic getLogic() {
        return this.entity.getLogic();
    }

    public void setLogic(Logic logic) {
        this.entity.setLogic(logic);
    }

    public Map<String, String> getConfig() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.entity.getConfig() != null) {
            result.putAll(this.entity.getConfig());
        }
        return Collections.unmodifiableMap(result);
    }

    public void setConfig(Map<String, String> config) {
        if (this.entity.getConfig() == null) {
            this.entity.setConfig(new HashMap<String, String>());
        } else {
            this.entity.getConfig().clear();
        }
        this.entity.getConfig().putAll(config);
    }

    public void removeConfig(String name) {
        if (this.entity.getConfig() == null) {
            return;
        }
        this.entity.getConfig().remove(name);
    }

    public void putConfig(String name, String value) {
        if (this.entity.getConfig() == null) {
            this.entity.setConfig(new HashMap<String, String>());
        }
        this.entity.getConfig().put(name, value);
    }

    public String getName() {
        return this.entity.getName();
    }

    public void setName(String name) {
        this.entity.setName(name);
    }

    public String getDescription() {
        return this.entity.getDescription();
    }

    public void setDescription(String description) {
        this.entity.setDescription(description);
    }

    public ResourceServer getResourceServer() {
        return this.storeFactory.getResourceServerStore().findById(this.entity.getResourceServer().getId());
    }

    public Set<Policy> getAssociatedPolicies() {
        HashSet<Policy> result = new HashSet<Policy>();
        for (PolicyEntity policy : this.entity.getAssociatedPolicies()) {
            Policy p = this.storeFactory.getPolicyStore().findById(policy.getId(), this.entity.getResourceServer().getId());
            result.add(p);
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<Resource> getResources() {
        HashSet<Resource> set = new HashSet<Resource>();
        for (ResourceEntity res : this.entity.getResources()) {
            set.add(this.storeFactory.getResourceStore().findById(res.getId(), this.entity.getResourceServer().getId()));
        }
        return Collections.unmodifiableSet(set);
    }

    public Set<Scope> getScopes() {
        HashSet<Scope> set = new HashSet<Scope>();
        for (ScopeEntity res : this.entity.getScopes()) {
            set.add(this.storeFactory.getScopeStore().findById(res.getId(), this.entity.getResourceServer().getId()));
        }
        return Collections.unmodifiableSet(set);
    }

    public void addScope(Scope scope) {
        this.entity.getScopes().add(ScopeAdapter.toEntity(this.em, scope));
    }

    public void removeScope(Scope scope) {
        this.entity.getScopes().remove(ScopeAdapter.toEntity(this.em, scope));
    }

    public void addAssociatedPolicy(Policy associatedPolicy) {
        this.entity.getAssociatedPolicies().add(PolicyAdapter.toEntity(this.em, associatedPolicy));
    }

    public void removeAssociatedPolicy(Policy associatedPolicy) {
        this.entity.getAssociatedPolicies().remove(PolicyAdapter.toEntity(this.em, associatedPolicy));
    }

    public void addResource(Resource resource) {
        this.entity.getResources().add(ResourceAdapter.toEntity(this.em, resource));
    }

    public void removeResource(Resource resource) {
        this.entity.getResources().remove(ResourceAdapter.toEntity(this.em, resource));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Policy)) {
            return false;
        }
        Policy that = (Policy)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public static PolicyEntity toEntity(EntityManager em, Policy policy) {
        if (policy instanceof PolicyAdapter) {
            return ((PolicyAdapter)policy).getEntity();
        }
        return (PolicyEntity)em.getReference(PolicyEntity.class, (Object)policy.getId());
    }
}

