/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import javax.persistence.EntityManager;
import org.keycloak.authorization.jpa.entities.ScopeEntity;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.jpa.JpaModel;

public class ScopeAdapter
implements Scope,
JpaModel<ScopeEntity> {
    private ScopeEntity entity;
    private EntityManager em;
    private StoreFactory storeFactory;

    public ScopeAdapter(ScopeEntity entity, EntityManager em, StoreFactory storeFactory) {
        this.entity = entity;
        this.em = em;
        this.storeFactory = storeFactory;
    }

    @Override
    public ScopeEntity getEntity() {
        return this.entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public String getName() {
        return this.entity.getName();
    }

    public void setName(String name) {
        this.entity.setName(name);
    }

    public String getDisplayName() {
        return this.entity.getDisplayName();
    }

    public void setDisplayName(String name) {
        this.entity.setDisplayName(name);
    }

    public String getIconUri() {
        return this.entity.getIconUri();
    }

    public void setIconUri(String iconUri) {
        this.entity.setIconUri(iconUri);
    }

    public ResourceServer getResourceServer() {
        return this.storeFactory.getResourceServerStore().findById(this.entity.getResourceServer().getId());
    }

    public static ScopeEntity toEntity(EntityManager em, Scope scope) {
        if (scope instanceof ScopeAdapter) {
            return ((ScopeAdapter)scope).getEntity();
        }
        return (ScopeEntity)em.getReference(ScopeEntity.class, (Object)scope.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Scope)) {
            return false;
        }
        Scope that = (Scope)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

