/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.jpa.JpaModel;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.entities.ClientTemplateEntity;
import org.keycloak.models.jpa.entities.ProtocolMapperEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.jpa.entities.TemplateScopeMappingEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class ClientTemplateAdapter
implements ClientTemplateModel,
JpaModel<ClientTemplateEntity> {
    protected KeycloakSession session;
    protected RealmModel realm;
    protected EntityManager em;
    protected ClientTemplateEntity entity;

    public ClientTemplateAdapter(RealmModel realm, EntityManager em, KeycloakSession session, ClientTemplateEntity entity) {
        this.session = session;
        this.realm = realm;
        this.em = em;
        this.entity = entity;
    }

    @Override
    public ClientTemplateEntity getEntity() {
        return this.entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public String getName() {
        return this.entity.getName();
    }

    public void setName(String name) {
        this.entity.setName(name);
    }

    public String getDescription() {
        return this.entity.getDescription();
    }

    public void setDescription(String description) {
        this.entity.setDescription(description);
    }

    public String getProtocol() {
        return this.entity.getProtocol();
    }

    public void setProtocol(String protocol) {
        this.entity.setProtocol(protocol);
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        HashSet<ProtocolMapperModel> mappings = new HashSet<ProtocolMapperModel>();
        for (ProtocolMapperEntity entity : this.entity.getProtocolMappers()) {
            ProtocolMapperModel mapping = new ProtocolMapperModel();
            mapping.setId(entity.getId());
            mapping.setName(entity.getName());
            mapping.setProtocol(entity.getProtocol());
            mapping.setProtocolMapper(entity.getProtocolMapper());
            mapping.setConsentRequired(entity.isConsentRequired());
            mapping.setConsentText(entity.getConsentText());
            HashMap<String, String> config = new HashMap<String, String>();
            if (entity.getConfig() != null) {
                config.putAll(entity.getConfig());
            }
            mapping.setConfig(config);
            mappings.add(mapping);
        }
        return mappings;
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        if (this.getProtocolMapperByName(model.getProtocol(), model.getName()) != null) {
            throw new ModelDuplicateException("Protocol mapper name must be unique per protocol");
        }
        String id = model.getId() != null ? model.getId() : KeycloakModelUtils.generateId();
        ProtocolMapperEntity entity = new ProtocolMapperEntity();
        entity.setId(id);
        entity.setName(model.getName());
        entity.setProtocol(model.getProtocol());
        entity.setProtocolMapper(model.getProtocolMapper());
        entity.setClientTemplate(this.entity);
        entity.setConfig(model.getConfig());
        entity.setConsentRequired(model.isConsentRequired());
        entity.setConsentText(model.getConsentText());
        this.em.persist((Object)entity);
        this.entity.getProtocolMappers().add(entity);
        return this.entityToModel(entity);
    }

    protected ProtocolMapperEntity getProtocolMapperEntity(String id) {
        for (ProtocolMapperEntity entity : this.entity.getProtocolMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected ProtocolMapperEntity getProtocolMapperEntityByName(String protocol, String name) {
        for (ProtocolMapperEntity entity : this.entity.getProtocolMappers()) {
            if (!entity.getProtocol().equals(protocol) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        ProtocolMapperEntity toDelete = this.getProtocolMapperEntity(mapping.getId());
        if (toDelete != null) {
            this.session.users().preRemove(mapping);
            this.entity.getProtocolMappers().remove(toDelete);
            this.em.remove((Object)toDelete);
        }
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntity(mapping.getId());
        entity.setProtocolMapper(mapping.getProtocolMapper());
        entity.setConsentRequired(mapping.isConsentRequired());
        entity.setConsentText(mapping.getConsentText());
        if (entity.getConfig() == null) {
            entity.setConfig(mapping.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapping.getConfig());
        }
        this.em.flush();
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntityByName(protocol, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected ProtocolMapperModel entityToModel(ProtocolMapperEntity entity) {
        ProtocolMapperModel mapping = new ProtocolMapperModel();
        mapping.setId(entity.getId());
        mapping.setName(entity.getName());
        mapping.setProtocol(entity.getProtocol());
        mapping.setProtocolMapper(entity.getProtocolMapper());
        mapping.setConsentRequired(entity.isConsentRequired());
        mapping.setConsentText(entity.getConsentText());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapping.setConfig(config);
        return mapping;
    }

    public boolean isFullScopeAllowed() {
        return this.entity.isFullScopeAllowed();
    }

    public void setFullScopeAllowed(boolean value) {
        this.entity.setFullScopeAllowed(value);
    }

    public Set<RoleModel> getRealmScopeMappings() {
        Set<RoleModel> roleMappings = this.getScopeMappings();
        HashSet<RoleModel> appRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel) || !((RealmModel)container).getId().equals(this.realm.getId())) continue;
            appRoles.add(role);
        }
        return appRoles;
    }

    public Set<RoleModel> getScopeMappings() {
        TypedQuery query = this.em.createNamedQuery("clientTemplateScopeMappingIds", String.class);
        query.setParameter("template", (Object)this.getEntity());
        List ids = query.getResultList();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String roleId : ids) {
            RoleModel role = this.realm.getRoleById(roleId);
            if (role == null) continue;
            roles.add(role);
        }
        return roles;
    }

    public void addScopeMapping(RoleModel role) {
        if (this.hasScope(role)) {
            return;
        }
        TemplateScopeMappingEntity entity = new TemplateScopeMappingEntity();
        entity.setTemplate(this.getEntity());
        RoleEntity roleEntity = RoleAdapter.toRoleEntity(role, this.em);
        entity.setRole(roleEntity);
        this.em.persist((Object)entity);
        this.em.flush();
        this.em.detach((Object)entity);
    }

    public void deleteScopeMapping(RoleModel role) {
        TypedQuery<TemplateScopeMappingEntity> query = this.getRealmScopeMappingQuery(role);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (TemplateScopeMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
    }

    protected TypedQuery<TemplateScopeMappingEntity> getRealmScopeMappingQuery(RoleModel role) {
        TypedQuery query = this.em.createNamedQuery("templateHasScope", TemplateScopeMappingEntity.class);
        query.setParameter("template", (Object)this.getEntity());
        RoleEntity roleEntity = RoleAdapter.toRoleEntity(role, this.em);
        query.setParameter("role", (Object)roleEntity);
        return query;
    }

    public boolean hasScope(RoleModel role) {
        if (this.isFullScopeAllowed()) {
            return true;
        }
        Set<RoleModel> roles = this.getScopeMappings();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public boolean isPublicClient() {
        return this.entity.isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        this.entity.setPublicClient(flag);
    }

    public boolean isFrontchannelLogout() {
        return this.entity.isFrontchannelLogout();
    }

    public void setFrontchannelLogout(boolean flag) {
        this.entity.setFrontchannelLogout(flag);
    }

    public void setAttribute(String name, String value) {
        this.entity.getAttributes().put(name, value);
    }

    public void removeAttribute(String name) {
        this.entity.getAttributes().remove(name);
    }

    public String getAttribute(String name) {
        return this.entity.getAttributes().get(name);
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.entity.getAttributes());
        return copy;
    }

    public boolean isBearerOnly() {
        return this.entity.isBearerOnly();
    }

    public void setBearerOnly(boolean only) {
        this.entity.setBearerOnly(only);
    }

    public boolean isConsentRequired() {
        return this.entity.isConsentRequired();
    }

    public void setConsentRequired(boolean consentRequired) {
        this.entity.setConsentRequired(consentRequired);
    }

    public boolean isStandardFlowEnabled() {
        return this.entity.isStandardFlowEnabled();
    }

    public void setStandardFlowEnabled(boolean standardFlowEnabled) {
        this.entity.setStandardFlowEnabled(standardFlowEnabled);
    }

    public boolean isImplicitFlowEnabled() {
        return this.entity.isImplicitFlowEnabled();
    }

    public void setImplicitFlowEnabled(boolean implicitFlowEnabled) {
        this.entity.setImplicitFlowEnabled(implicitFlowEnabled);
    }

    public boolean isDirectAccessGrantsEnabled() {
        return this.entity.isDirectAccessGrantsEnabled();
    }

    public void setDirectAccessGrantsEnabled(boolean directAccessGrantsEnabled) {
        this.entity.setDirectAccessGrantsEnabled(directAccessGrantsEnabled);
    }

    public boolean isServiceAccountsEnabled() {
        return this.entity.isServiceAccountsEnabled();
    }

    public void setServiceAccountsEnabled(boolean serviceAccountsEnabled) {
        this.entity.setServiceAccountsEnabled(serviceAccountsEnabled);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ClientTemplateModel)) {
            return false;
        }
        ClientTemplateModel that = (ClientTemplateModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

