/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.filter;

import java.util.List;
import liquibase.change.Change;
import liquibase.change.core.TagDatabaseChange;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;

public class UpToTagChangeSetFilter
implements ChangeSetFilter {
    private final String tag;
    private boolean seenTag = false;

    public UpToTagChangeSetFilter(String tag, List<RanChangeSet> ranChangeSets) {
        this.tag = tag;
        for (RanChangeSet ranChangeSet : ranChangeSets) {
            if (!tag.equalsIgnoreCase(ranChangeSet.getTag())) continue;
            this.seenTag = true;
            break;
        }
    }

    @Override
    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
        if (this.seenTag) {
            return new ChangeSetFilterResult(false, "Change set is after tag '" + this.tag + "'", this.getClass());
        }
        String tag = null;
        for (Change change : changeSet.getChanges()) {
            if (!(change instanceof TagDatabaseChange)) continue;
            tag = ((TagDatabaseChange)change).getTag();
        }
        if (this.tag.equals(tag)) {
            this.seenTag = true;
        }
        return new ChangeSetFilterResult(true, "Change set is at or before tag '" + this.tag + "'", this.getClass());
    }
}

