/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.attr;

import java.net.URI;
import java.util.HashMap;
import java.util.Set;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.UnknownIdentifierException;
import org.jboss.security.xacml.sunxacml.attr.AttributeFactoryProxy;
import org.jboss.security.xacml.sunxacml.attr.AttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.StandardAttributeFactory;
import org.w3c.dom.Node;

public abstract class AttributeFactory {
    private static AttributeFactoryProxy defaultFactoryProxy;
    private static HashMap registeredFactories;

    protected AttributeFactory() {
    }

    public static final AttributeFactory getInstance() {
        return defaultFactoryProxy.getFactory();
    }

    public static final AttributeFactory getInstance(String identifier) throws UnknownIdentifierException {
        AttributeFactoryProxy proxy = (AttributeFactoryProxy)registeredFactories.get(identifier);
        if (proxy == null) {
            throw new UnknownIdentifierException("Uknown AttributeFactory identifier: " + identifier);
        }
        return proxy.getFactory();
    }

    public static final void setDefaultFactory(AttributeFactoryProxy proxy) {
        defaultFactoryProxy = proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void registerFactory(String identifier, AttributeFactoryProxy proxy) throws IllegalArgumentException {
        HashMap hashMap = registeredFactories;
        synchronized (hashMap) {
            if (registeredFactories.containsKey(identifier)) {
                throw new IllegalArgumentException("Identifier is already registered as AttributeFactory: " + identifier);
            }
            registeredFactories.put(identifier, proxy);
        }
    }

    public abstract void addDatatype(String var1, AttributeProxy var2);

    public static void addAttributeProxy(String id, AttributeProxy proxy) {
        AttributeFactory.getInstance().addDatatype(id, proxy);
    }

    public abstract Set getSupportedDatatypes();

    public abstract AttributeValue createValue(Node var1) throws UnknownIdentifierException, ParsingException;

    public static AttributeValue createAttribute(Node root) throws UnknownIdentifierException, ParsingException {
        return AttributeFactory.getInstance().createValue(root);
    }

    public abstract AttributeValue createValue(Node var1, URI var2) throws UnknownIdentifierException, ParsingException;

    public static AttributeValue createAttribute(Node root, URI dataType) throws UnknownIdentifierException, ParsingException {
        return AttributeFactory.getInstance().createValue(root, dataType);
    }

    public abstract AttributeValue createValue(Node var1, String var2) throws UnknownIdentifierException, ParsingException;

    public static AttributeValue createAttribute(Node root, String type) throws UnknownIdentifierException, ParsingException {
        return AttributeFactory.getInstance().createValue(root, type);
    }

    public abstract AttributeValue createValue(URI var1, String var2) throws UnknownIdentifierException, ParsingException;

    public static AttributeValue createAttribute(URI dataType, String value) throws UnknownIdentifierException, ParsingException {
        return AttributeFactory.getInstance().createValue(dataType, value);
    }

    static {
        AttributeFactoryProxy proxy = new AttributeFactoryProxy(){

            public AttributeFactory getFactory() {
                return StandardAttributeFactory.getFactory();
            }
        };
        registeredFactories = new HashMap();
        registeredFactories.put("urn:oasis:names:tc:xacml:1.0:policy", proxy);
        registeredFactories.put("urn:oasis:names:tc:xacml:2.0:policy:schema:os", proxy);
        defaultFactoryProxy = proxy;
    }
}

