/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.buffers.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.UTF8Util;

public class ChannelBufferWrapper
implements ActiveMQBuffer {
    protected ByteBuf buffer;
    private final boolean releasable;
    private final boolean isPooled;

    public static ByteBuf unwrap(ByteBuf buffer) {
        ByteBuf parent;
        while ((parent = buffer.unwrap()) != null && parent != buffer) {
            buffer = parent;
        }
        return buffer;
    }

    public ChannelBufferWrapper(ByteBuf buffer) {
        this(buffer, false);
    }

    public ChannelBufferWrapper(ByteBuf buffer, boolean releasable) {
        this(buffer, releasable, false);
    }

    public ChannelBufferWrapper(ByteBuf buffer, boolean releasable, boolean pooled) {
        this.buffer = !releasable ? Unpooled.unreleasableBuffer(buffer) : buffer;
        this.releasable = releasable;
        this.isPooled = pooled;
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    @Override
    public SimpleString readNullableSimpleString() {
        byte b = this.buffer.readByte();
        if (b == 0) {
            return null;
        }
        return this.readSimpleStringInternal();
    }

    @Override
    public String readNullableString() {
        byte b = this.buffer.readByte();
        if (b == 0) {
            return null;
        }
        return this.readStringInternal();
    }

    @Override
    public SimpleString readSimpleString() {
        return this.readSimpleStringInternal();
    }

    private SimpleString readSimpleStringInternal() {
        int len = this.buffer.readInt();
        byte[] data = new byte[len];
        this.buffer.readBytes(data);
        return new SimpleString(data);
    }

    @Override
    public String readString() {
        return this.readStringInternal();
    }

    private String readStringInternal() {
        int len = this.buffer.readInt();
        if (len < 9) {
            char[] chars = new char[len];
            for (int i = 0; i < len; ++i) {
                chars[i] = (char)this.buffer.readShort();
            }
            return new String(chars);
        }
        if (len < 4095) {
            return this.readUTF();
        }
        return this.readSimpleStringInternal().toString();
    }

    @Override
    public String readUTF() {
        return UTF8Util.readUTF(this);
    }

    @Override
    public void writeBoolean(boolean val) {
        this.buffer.writeByte((byte)(val ? -1 : 0));
    }

    @Override
    public void writeNullableSimpleString(SimpleString val) {
        if (val == null) {
            this.buffer.writeByte(0);
        } else {
            this.buffer.writeByte(1);
            this.writeSimpleStringInternal(val);
        }
    }

    @Override
    public void writeNullableString(String val) {
        if (val == null) {
            this.buffer.writeByte(0);
        } else {
            this.buffer.writeByte(1);
            this.writeStringInternal(val);
        }
    }

    @Override
    public void writeSimpleString(SimpleString val) {
        this.writeSimpleStringInternal(val);
    }

    private void writeSimpleStringInternal(SimpleString val) {
        byte[] data = val.getData();
        this.buffer.writeInt(data.length);
        this.buffer.writeBytes(data);
    }

    @Override
    public void writeString(String val) {
        this.writeStringInternal(val);
    }

    private void writeStringInternal(String val) {
        int length = val.length();
        this.buffer.writeInt(length);
        if (length < 9) {
            for (int i = 0; i < val.length(); ++i) {
                this.buffer.writeShort((short)val.charAt(i));
            }
        } else if (length < 4095) {
            this.writeUTF(val);
        } else {
            this.writeSimpleStringInternal(new SimpleString(val));
        }
    }

    @Override
    public void writeUTF(String utf) {
        UTF8Util.saveUTF(this, utf);
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public ByteBuf byteBuf() {
        return this.buffer;
    }

    @Override
    public void clear() {
        this.buffer.clear();
    }

    @Override
    public ActiveMQBuffer copy() {
        return new ChannelBufferWrapper(this.buffer.copy(), this.releasable);
    }

    @Override
    public ActiveMQBuffer copy(int index, int length) {
        return new ChannelBufferWrapper(this.buffer.copy(index, length), this.releasable);
    }

    @Override
    public void discardReadBytes() {
        this.buffer.discardReadBytes();
    }

    @Override
    public ActiveMQBuffer duplicate() {
        return new ChannelBufferWrapper(this.buffer.duplicate(), this.releasable);
    }

    @Override
    public byte getByte(int index) {
        return this.buffer.getByte(index);
    }

    @Override
    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, byte[] dst) {
        this.buffer.getBytes(index, dst);
    }

    @Override
    public void getBytes(int index, ByteBuffer dst) {
        this.buffer.getBytes(index, dst);
    }

    @Override
    public void getBytes(int index, ActiveMQBuffer dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst.byteBuf(), dstIndex, length);
    }

    @Override
    public void getBytes(int index, ActiveMQBuffer dst, int length) {
        this.buffer.getBytes(index, dst.byteBuf(), length);
    }

    @Override
    public void getBytes(int index, ActiveMQBuffer dst) {
        this.buffer.getBytes(index, dst.byteBuf());
    }

    @Override
    public char getChar(int index) {
        return (char)this.buffer.getShort(index);
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.buffer.getLong(index));
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat(this.buffer.getInt(index));
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    @Override
    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    @Override
    public short getUnsignedByte(int index) {
        return this.buffer.getUnsignedByte(index);
    }

    @Override
    public long getUnsignedInt(int index) {
        return this.buffer.getUnsignedInt(index);
    }

    @Override
    public int getUnsignedShort(int index) {
        return this.buffer.getUnsignedShort(index);
    }

    @Override
    public void markReaderIndex() {
        this.buffer.markReaderIndex();
    }

    @Override
    public void markWriterIndex() {
        this.buffer.markWriterIndex();
    }

    @Override
    public boolean readable() {
        return this.buffer.isReadable();
    }

    @Override
    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    @Override
    public byte readByte() {
        return this.buffer.readByte();
    }

    @Override
    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.buffer.readBytes(dst, dstIndex, length);
    }

    @Override
    public void readBytes(byte[] dst) {
        this.buffer.readBytes(dst);
    }

    @Override
    public void readBytes(ByteBuffer dst) {
        this.buffer.readBytes(dst);
    }

    @Override
    public void readBytes(ActiveMQBuffer dst, int dstIndex, int length) {
        this.buffer.readBytes(dst.byteBuf(), dstIndex, length);
    }

    @Override
    public void readBytes(ActiveMQBuffer dst, int length) {
        this.buffer.readBytes(dst.byteBuf(), length);
    }

    @Override
    public void readBytes(ActiveMQBuffer dst) {
        this.buffer.readBytes(dst.byteBuf());
    }

    @Override
    public ActiveMQBuffer readBytes(int length) {
        return new ChannelBufferWrapper(this.buffer.readBytes(length), this.releasable);
    }

    @Override
    public char readChar() {
        return (char)this.buffer.readShort();
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.buffer.readLong());
    }

    @Override
    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    @Override
    public void readerIndex(int readerIndex) {
        this.buffer.readerIndex(readerIndex);
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.buffer.readInt());
    }

    @Override
    public int readInt() {
        return this.buffer.readInt();
    }

    @Override
    public long readLong() {
        return this.buffer.readLong();
    }

    @Override
    public short readShort() {
        return this.buffer.readShort();
    }

    @Override
    public ActiveMQBuffer readSlice(int length) {
        if (this.isPooled) {
            ByteBuf fromBuffer = this.buffer.readSlice(length);
            ByteBuf newNettyBuffer = Unpooled.buffer(fromBuffer.capacity());
            int read = fromBuffer.readerIndex();
            int writ = fromBuffer.writerIndex();
            fromBuffer.readerIndex(0);
            fromBuffer.readBytes(newNettyBuffer, 0, writ);
            newNettyBuffer.setIndex(read, writ);
            ChannelBufferWrapper returnBuffer = new ChannelBufferWrapper(newNettyBuffer, this.releasable, false);
            returnBuffer.setIndex(read, writ);
            return returnBuffer;
        }
        return new ChannelBufferWrapper(this.buffer.readSlice(length), this.releasable, this.isPooled);
    }

    @Override
    public int readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    @Override
    public long readUnsignedInt() {
        return this.buffer.readUnsignedInt();
    }

    @Override
    public int readUnsignedShort() {
        return this.buffer.readUnsignedShort();
    }

    @Override
    public void resetReaderIndex() {
        this.buffer.resetReaderIndex();
    }

    @Override
    public void resetWriterIndex() {
        this.buffer.resetWriterIndex();
    }

    @Override
    public void setByte(int index, byte value) {
        this.buffer.setByte(index, value);
    }

    @Override
    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
    }

    @Override
    public void setBytes(int index, byte[] src) {
        this.buffer.setBytes(index, src);
    }

    @Override
    public void setBytes(int index, ByteBuffer src) {
        this.buffer.setBytes(index, src);
    }

    @Override
    public void setBytes(int index, ActiveMQBuffer src, int srcIndex, int length) {
        this.buffer.setBytes(index, src.byteBuf(), srcIndex, length);
    }

    @Override
    public void setBytes(int index, ActiveMQBuffer src, int length) {
        this.buffer.setBytes(index, src.byteBuf(), length);
    }

    @Override
    public void setBytes(int index, ActiveMQBuffer src) {
        this.buffer.setBytes(index, src.byteBuf());
    }

    @Override
    public void setChar(int index, char value) {
        this.buffer.setShort(index, (short)value);
    }

    @Override
    public void setDouble(int index, double value) {
        this.buffer.setLong(index, Double.doubleToLongBits(value));
    }

    @Override
    public void setFloat(int index, float value) {
        this.buffer.setInt(index, Float.floatToIntBits(value));
    }

    @Override
    public void setIndex(int readerIndex, int writerIndex) {
        this.buffer.setIndex(readerIndex, writerIndex);
    }

    @Override
    public void setInt(int index, int value) {
        this.buffer.setInt(index, value);
    }

    @Override
    public void setLong(int index, long value) {
        this.buffer.setLong(index, value);
    }

    @Override
    public void setShort(int index, short value) {
        this.buffer.setShort(index, value);
    }

    @Override
    public int skipBytes(int length) {
        this.buffer.skipBytes(length);
        return length;
    }

    @Override
    public ActiveMQBuffer slice() {
        return new ChannelBufferWrapper(this.buffer.slice(), this.releasable);
    }

    @Override
    public ActiveMQBuffer slice(int index, int length) {
        return new ChannelBufferWrapper(this.buffer.slice(index, length), this.releasable);
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.buffer.nioBuffer();
    }

    @Override
    public ByteBuffer toByteBuffer(int index, int length) {
        return this.buffer.nioBuffer(index, length);
    }

    @Override
    public void release() {
        if (this.isPooled) {
            this.buffer.release();
        }
    }

    @Override
    public boolean writable() {
        return this.buffer.isWritable();
    }

    @Override
    public int writableBytes() {
        return this.buffer.writableBytes();
    }

    @Override
    public void writeByte(byte value) {
        this.buffer.writeByte(value);
    }

    @Override
    public void writeBytes(byte[] src, int srcIndex, int length) {
        this.buffer.writeBytes(src, srcIndex, length);
    }

    @Override
    public void writeBytes(byte[] src) {
        this.buffer.writeBytes(src);
    }

    @Override
    public void writeBytes(ByteBuffer src) {
        this.buffer.writeBytes(src);
    }

    @Override
    public void writeBytes(ByteBuf src, int srcIndex, int length) {
        this.buffer.writeBytes(src, srcIndex, length);
    }

    @Override
    public void writeBytes(ActiveMQBuffer src, int srcIndex, int length) {
        this.buffer.writeBytes(src.byteBuf(), srcIndex, length);
    }

    @Override
    public void writeBytes(ActiveMQBuffer src, int length) {
        this.buffer.writeBytes(src.byteBuf(), length);
    }

    @Override
    public void writeChar(char chr) {
        this.buffer.writeShort((short)chr);
    }

    @Override
    public void writeDouble(double value) {
        this.buffer.writeLong(Double.doubleToLongBits(value));
    }

    @Override
    public void writeFloat(float value) {
        this.buffer.writeInt(Float.floatToIntBits(value));
    }

    @Override
    public void writeInt(int value) {
        this.buffer.writeInt(value);
    }

    @Override
    public void writeLong(long value) {
        this.buffer.writeLong(value);
    }

    @Override
    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    @Override
    public void writerIndex(int writerIndex) {
        this.buffer.writerIndex(writerIndex);
    }

    @Override
    public void writeShort(short value) {
        this.buffer.writeShort(value);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readBytes(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.readBytes(b, off, len);
    }

    @Override
    public String readLine() throws IOException {
        return ByteUtil.readLine(this);
    }
}

