/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol;

import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;

public abstract class AbstractLoginProtocolFactory
implements LoginProtocolFactory {
    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(new ProviderEventListener(){

            public void onEvent(ProviderEvent event) {
                if (event instanceof RealmModel.ClientCreationEvent) {
                    ClientModel client = ((RealmModel.ClientCreationEvent)event).getCreatedClient();
                    AbstractLoginProtocolFactory.this.addDefaultClientScopes(client.getRealm(), client);
                    AbstractLoginProtocolFactory.this.addDefaults(client);
                }
            }
        });
    }

    @Override
    public void createDefaultClientScopes(RealmModel newRealm, boolean addScopesToExistingClients) {
        this.createDefaultClientScopesImpl(newRealm);
        if (addScopesToExistingClients) {
            for (ClientModel client : newRealm.getClients()) {
                this.addDefaultClientScopes(newRealm, client);
            }
        }
    }

    protected abstract void createDefaultClientScopesImpl(RealmModel var1);

    protected void addDefaultClientScopes(RealmModel realm, ClientModel newClient) {
        for (ClientScopeModel clientScope : realm.getDefaultClientScopes(true)) {
            if (!this.getId().equals(clientScope.getProtocol())) continue;
            newClient.addClientScope(clientScope, true);
        }
        for (ClientScopeModel clientScope : realm.getDefaultClientScopes(false)) {
            if (!this.getId().equals(clientScope.getProtocol())) continue;
            newClient.addClientScope(clientScope, false);
        }
    }

    protected abstract void addDefaults(ClientModel var1);

    public void close() {
    }
}

