/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.component.ComponentModel;
import org.keycloak.migration.MigrationModel;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.CachedObject;
import org.keycloak.models.cache.CachedRealmModel;
import org.keycloak.models.cache.infinispan.ClearCacheEvent;
import org.keycloak.models.cache.infinispan.ClientAdapter;
import org.keycloak.models.cache.infinispan.ClientScopeAdapter;
import org.keycloak.models.cache.infinispan.GroupAdapter;
import org.keycloak.models.cache.infinispan.RealmAdapter;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.RoleAdapter;
import org.keycloak.models.cache.infinispan.entities.CachedClient;
import org.keycloak.models.cache.infinispan.entities.CachedClientRole;
import org.keycloak.models.cache.infinispan.entities.CachedClientScope;
import org.keycloak.models.cache.infinispan.entities.CachedGroup;
import org.keycloak.models.cache.infinispan.entities.CachedRealm;
import org.keycloak.models.cache.infinispan.entities.CachedRealmRole;
import org.keycloak.models.cache.infinispan.entities.CachedRole;
import org.keycloak.models.cache.infinispan.entities.ClientListQuery;
import org.keycloak.models.cache.infinispan.entities.GroupListQuery;
import org.keycloak.models.cache.infinispan.entities.RealmListQuery;
import org.keycloak.models.cache.infinispan.entities.RoleListQuery;
import org.keycloak.models.cache.infinispan.events.ClientAddedEvent;
import org.keycloak.models.cache.infinispan.events.ClientRemovedEvent;
import org.keycloak.models.cache.infinispan.events.ClientTemplateEvent;
import org.keycloak.models.cache.infinispan.events.ClientUpdatedEvent;
import org.keycloak.models.cache.infinispan.events.GroupAddedEvent;
import org.keycloak.models.cache.infinispan.events.GroupMovedEvent;
import org.keycloak.models.cache.infinispan.events.GroupRemovedEvent;
import org.keycloak.models.cache.infinispan.events.GroupUpdatedEvent;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmRemovedEvent;
import org.keycloak.models.cache.infinispan.events.RealmUpdatedEvent;
import org.keycloak.models.cache.infinispan.events.RoleAddedEvent;
import org.keycloak.models.cache.infinispan.events.RoleRemovedEvent;
import org.keycloak.models.cache.infinispan.events.RoleUpdatedEvent;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.storage.CacheableStorageProviderModel;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.client.ClientStorageProviderModel;

public class RealmCacheSession
implements CacheRealmProvider {
    protected static final Logger logger = Logger.getLogger(RealmCacheSession.class);
    public static final String REALM_CLIENTS_QUERY_SUFFIX = ".realm.clients";
    public static final String ROLES_QUERY_SUFFIX = ".roles";
    protected RealmCacheManager cache;
    protected KeycloakSession session;
    protected RealmProvider realmDelegate;
    protected ClientProvider clientDelegate;
    protected boolean transactionActive;
    protected boolean setRollbackOnly;
    protected Map<String, RealmAdapter> managedRealms = new HashMap<String, RealmAdapter>();
    protected Map<String, ClientModel> managedApplications = new HashMap<String, ClientModel>();
    protected Map<String, ClientScopeAdapter> managedClientScopes = new HashMap<String, ClientScopeAdapter>();
    protected Map<String, RoleAdapter> managedRoles = new HashMap<String, RoleAdapter>();
    protected Map<String, GroupAdapter> managedGroups = new HashMap<String, GroupAdapter>();
    protected Set<String> listInvalidations = new HashSet<String>();
    protected Set<String> invalidations = new HashSet<String>();
    protected Set<InvalidationEvent> invalidationEvents = new HashSet<InvalidationEvent>();
    protected boolean clearAll;
    protected final long startupRevision;

    public RealmCacheSession(RealmCacheManager cache, KeycloakSession session) {
        this.cache = cache;
        this.session = session;
        this.startupRevision = cache.getCurrentCounter();
        session.getTransactionManager().enlistPrepare(this.getPrepareTransaction());
        session.getTransactionManager().enlistAfterCompletion(this.getAfterTransaction());
    }

    public long getStartupRevision() {
        return this.startupRevision;
    }

    public boolean isInvalid(String id) {
        return this.invalidations.contains(id);
    }

    public void clear() {
        ClusterProvider cluster = (ClusterProvider)this.session.getProvider(ClusterProvider.class);
        cluster.notify("REALM_CLEAR_CACHE_EVENTS", (ClusterEvent)new ClearCacheEvent(), false, ClusterProvider.DCNotify.ALL_DCS);
    }

    public MigrationModel getMigrationModel() {
        return this.getRealmDelegate().getMigrationModel();
    }

    public RealmProvider getRealmDelegate() {
        if (!this.transactionActive) {
            throw new IllegalStateException("Cannot access delegate without a transaction");
        }
        if (this.realmDelegate != null) {
            return this.realmDelegate;
        }
        this.realmDelegate = this.session.realmLocalStorage();
        return this.realmDelegate;
    }

    public ClientProvider getClientDelegate() {
        if (!this.transactionActive) {
            throw new IllegalStateException("Cannot access delegate without a transaction");
        }
        if (this.clientDelegate != null) {
            return this.clientDelegate;
        }
        this.clientDelegate = this.session.clientStorageManager();
        return this.clientDelegate;
    }

    public void registerRealmInvalidation(String id, String name) {
        this.cache.realmUpdated(id, name, this.invalidations);
        RealmAdapter adapter = this.managedRealms.get(id);
        if (adapter != null) {
            adapter.invalidateFlag();
        }
        this.invalidationEvents.add(RealmUpdatedEvent.create(id, name));
    }

    public void registerClientInvalidation(String id, String clientId, String realmId) {
        this.invalidateClient(id);
        this.invalidationEvents.add(ClientUpdatedEvent.create(id, clientId, realmId));
        this.cache.clientUpdated(realmId, id, clientId, this.invalidations);
    }

    private void invalidateClient(String id) {
        this.invalidations.add(id);
        ClientModel adapter = this.managedApplications.get(id);
        if (adapter != null && adapter instanceof ClientAdapter) {
            ((ClientAdapter)adapter).invalidate();
        }
    }

    public void registerClientScopeInvalidation(String id) {
        this.invalidateClientScope(id);
        this.invalidationEvents.add(ClientTemplateEvent.create(id));
    }

    private void invalidateClientScope(String id) {
        this.invalidations.add(id);
        ClientScopeAdapter adapter = this.managedClientScopes.get(id);
        if (adapter != null) {
            adapter.invalidate();
        }
    }

    public void registerRoleInvalidation(String id, String roleName, String roleContainerId) {
        this.invalidateRole(id);
        this.cache.roleUpdated(roleContainerId, roleName, this.invalidations);
        this.invalidationEvents.add(RoleUpdatedEvent.create(id, roleName, roleContainerId));
    }

    private void roleRemovalInvalidations(String roleId, String roleName, String roleContainerId) {
        HashSet<String> newInvalidations = new HashSet<String>();
        this.cache.roleRemoval(roleId, roleName, roleContainerId, newInvalidations);
        this.invalidations.addAll(newInvalidations);
        for (String id : newInvalidations) {
            ClientModel adapter = this.managedApplications.get(id);
            if (adapter != null && adapter instanceof ClientAdapter) {
                ((ClientAdapter)adapter).invalidate();
                continue;
            }
            GroupAdapter group = this.managedGroups.get(id);
            if (group != null) {
                group.invalidate();
                continue;
            }
            ClientScopeAdapter clientScope = this.managedClientScopes.get(id);
            if (clientScope != null) {
                clientScope.invalidate();
                continue;
            }
            RoleAdapter role = this.managedRoles.get(id);
            if (role == null) continue;
            role.invalidate();
        }
    }

    private void invalidateRole(String id) {
        this.invalidations.add(id);
        RoleAdapter adapter = this.managedRoles.get(id);
        if (adapter != null) {
            adapter.invalidate();
        }
    }

    private void addedRole(String roleId, String roleContainerId) {
        this.listInvalidations.add(roleContainerId);
        this.invalidateRole(roleId);
        this.cache.roleAdded(roleContainerId, this.invalidations);
        this.invalidationEvents.add(RoleAddedEvent.create(roleId, roleContainerId));
    }

    public void registerGroupInvalidation(String id) {
        this.invalidateGroup(id, null, false);
        this.addGroupEventIfAbsent(GroupUpdatedEvent.create(id));
    }

    private void invalidateGroup(String id, String realmId, boolean invalidateQueries) {
        this.invalidateGroup(id);
        if (invalidateQueries) {
            this.cache.groupQueriesInvalidations(realmId, this.invalidations);
        }
    }

    private void invalidateGroup(String id) {
        this.invalidations.add(id);
        GroupAdapter adapter = this.managedGroups.get(id);
        if (adapter != null) {
            adapter.invalidate();
        }
    }

    protected void runInvalidations() {
        for (String id : this.invalidations) {
            this.cache.invalidateObject(id);
        }
        this.cache.sendInvalidationEvents(this.session, this.invalidationEvents, "REALM_INVALIDATION_EVENTS");
    }

    private KeycloakTransaction getPrepareTransaction() {
        return new KeycloakTransaction(){

            public void begin() {
                RealmCacheSession.this.transactionActive = true;
            }

            public void commit() {
            }

            public void rollback() {
                RealmCacheSession.this.setRollbackOnly = true;
                RealmCacheSession.this.transactionActive = false;
            }

            public void setRollbackOnly() {
                RealmCacheSession.this.setRollbackOnly = true;
            }

            public boolean getRollbackOnly() {
                return RealmCacheSession.this.setRollbackOnly;
            }

            public boolean isActive() {
                return RealmCacheSession.this.transactionActive;
            }
        };
    }

    private KeycloakTransaction getAfterTransaction() {
        return new KeycloakTransaction(){

            public void begin() {
                RealmCacheSession.this.transactionActive = true;
            }

            public void commit() {
                try {
                    if (RealmCacheSession.this.clearAll) {
                        RealmCacheSession.this.cache.clear();
                    }
                    RealmCacheSession.this.runInvalidations();
                    RealmCacheSession.this.transactionActive = false;
                }
                finally {
                    RealmCacheSession.this.cache.endRevisionBatch();
                }
            }

            public void rollback() {
                try {
                    RealmCacheSession.this.setRollbackOnly = true;
                    RealmCacheSession.this.runInvalidations();
                    RealmCacheSession.this.transactionActive = false;
                }
                finally {
                    RealmCacheSession.this.cache.endRevisionBatch();
                }
            }

            public void setRollbackOnly() {
                RealmCacheSession.this.setRollbackOnly = true;
            }

            public boolean getRollbackOnly() {
                return RealmCacheSession.this.setRollbackOnly;
            }

            public boolean isActive() {
                return RealmCacheSession.this.transactionActive;
            }
        };
    }

    public RealmModel createRealm(String name) {
        RealmModel realm = this.getRealmDelegate().createRealm(name);
        this.registerRealmInvalidation(realm.getId(), realm.getName());
        return realm;
    }

    public RealmModel createRealm(String id, String name) {
        RealmModel realm = this.getRealmDelegate().createRealm(id, name);
        this.registerRealmInvalidation(realm.getId(), realm.getName());
        return realm;
    }

    public RealmModel getRealm(String id) {
        CachedRealm cached = this.cache.get(id, CachedRealm.class);
        if (cached != null) {
            logger.tracev("by id cache hit: {0}", (Object)cached.getName());
        }
        boolean wasCached = false;
        if (cached == null) {
            Long loaded = this.cache.getCurrentRevision(id);
            RealmModel model = this.getRealmDelegate().getRealm(id);
            if (model == null) {
                return null;
            }
            if (this.invalidations.contains(id)) {
                return model;
            }
            cached = new CachedRealm(loaded, model);
            this.cache.addRevisioned(cached, this.startupRevision);
            wasCached = true;
        } else {
            if (this.invalidations.contains(id)) {
                return this.getRealmDelegate().getRealm(id);
            }
            if (this.managedRealms.containsKey(id)) {
                return (RealmModel)this.managedRealms.get(id);
            }
        }
        final RealmAdapter adapter = new RealmAdapter(this.session, cached, this);
        if (wasCached) {
            CachedRealmModel.RealmCachedEvent event = new CachedRealmModel.RealmCachedEvent(){

                public CachedRealmModel getRealm() {
                    return adapter;
                }

                public KeycloakSession getKeycloakSession() {
                    return RealmCacheSession.this.session;
                }
            };
            this.session.getKeycloakSessionFactory().publish((ProviderEvent)event);
        }
        this.managedRealms.put(id, adapter);
        return adapter;
    }

    public RealmModel getRealmByName(String name) {
        String cacheKey = RealmCacheSession.getRealmByNameCacheKey(name);
        RealmListQuery query = this.cache.get(cacheKey, RealmListQuery.class);
        if (query != null) {
            logger.tracev("realm by name cache hit: {0}", (Object)name);
        }
        if (query == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            RealmModel model = this.getRealmDelegate().getRealmByName(name);
            if (model == null) {
                return null;
            }
            if (this.invalidations.contains(model.getId())) {
                return model;
            }
            query = new RealmListQuery(loaded, cacheKey, model.getId());
            this.cache.addRevisioned(query, this.startupRevision);
            return model;
        }
        if (this.invalidations.contains(cacheKey)) {
            return this.getRealmDelegate().getRealmByName(name);
        }
        String realmId = query.getRealms().iterator().next();
        if (this.invalidations.contains(realmId)) {
            return this.getRealmDelegate().getRealmByName(name);
        }
        return this.getRealm(realmId);
    }

    static String getRealmByNameCacheKey(String name) {
        return "realm.query.by.name." + name;
    }

    public List<RealmModel> getRealms() {
        List backendRealms = this.getRealmDelegate().getRealms();
        LinkedList<RealmModel> cachedRealms = new LinkedList<RealmModel>();
        for (RealmModel realm : backendRealms) {
            RealmModel cached = this.getRealm(realm.getId());
            cachedRealms.add(cached);
        }
        return cachedRealms;
    }

    public boolean removeRealm(String id) {
        RealmModel realm = this.getRealm(id);
        if (realm == null) {
            return false;
        }
        this.evictRealmOnRemoval(realm);
        return this.getRealmDelegate().removeRealm(id);
    }

    public void evictRealmOnRemoval(RealmModel realm) {
        this.cache.invalidateObject(realm.getId());
        this.invalidationEvents.add(RealmRemovedEvent.create(realm.getId(), realm.getName()));
        this.cache.realmRemoval(realm.getId(), realm.getName(), this.invalidations);
    }

    public ClientModel addClient(RealmModel realm, String clientId) {
        ClientModel client = this.getRealmDelegate().addClient(realm, clientId);
        return this.addedClient(realm, client);
    }

    public ClientModel addClient(RealmModel realm, String id, String clientId) {
        ClientModel client = this.getRealmDelegate().addClient(realm, id, clientId);
        return this.addedClient(realm, client);
    }

    private ClientModel addedClient(RealmModel realm, ClientModel client) {
        logger.trace((Object)"added Client.....");
        this.invalidateClient(client.getId());
        this.listInvalidations.add(realm.getId());
        this.invalidationEvents.add(ClientAddedEvent.create(client.getId(), client.getClientId(), realm.getId()));
        this.cache.clientAdded(realm.getId(), client.getId(), client.getClientId(), this.invalidations);
        return client;
    }

    static String getRealmClientsQueryCacheKey(String realm) {
        return realm + REALM_CLIENTS_QUERY_SUFFIX;
    }

    static String getGroupsQueryCacheKey(String realm) {
        return realm + ".groups";
    }

    static String getTopGroupsQueryCacheKey(String realm) {
        return realm + ".top.groups";
    }

    static String getRolesCacheKey(String container) {
        return container + ROLES_QUERY_SUFFIX;
    }

    static String getRoleByNameCacheKey(String container, String name) {
        return container + "." + name + ROLES_QUERY_SUFFIX;
    }

    public List<ClientModel> getClients(RealmModel realm) {
        boolean queryDB;
        String cacheKey = RealmCacheSession.getRealmClientsQueryCacheKey(realm.getId());
        boolean bl = queryDB = this.invalidations.contains(cacheKey) || this.listInvalidations.contains(realm.getId());
        if (queryDB) {
            return this.getClientDelegate().getClients(realm);
        }
        ClientListQuery query = this.cache.get(cacheKey, ClientListQuery.class);
        if (query != null) {
            logger.tracev("getClients cache hit: {0}", (Object)realm.getName());
        }
        if (query == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            List model = this.getClientDelegate().getClients(realm);
            if (model == null) {
                return null;
            }
            HashSet<String> ids = new HashSet<String>();
            for (ClientModel client : model) {
                ids.add(client.getId());
            }
            query = new ClientListQuery(loaded, cacheKey, realm, ids);
            logger.tracev("adding realm clients cache miss: realm {0} key {1}", (Object)realm.getName(), (Object)cacheKey);
            this.cache.addRevisioned(query, this.startupRevision);
            return model;
        }
        LinkedList<ClientModel> list = new LinkedList<ClientModel>();
        for (String id : query.getClients()) {
            ClientModel client = this.session.realms().getClientById(id, realm);
            if (client == null) {
                this.invalidations.add(cacheKey);
                return this.getRealmDelegate().getClients(realm);
            }
            list.add(client);
        }
        return list;
    }

    public boolean removeClient(String id, RealmModel realm) {
        ClientModel client = this.getClientById(id, realm);
        if (client == null) {
            return false;
        }
        this.invalidateClient(client.getId());
        this.listInvalidations.add(realm.getId());
        this.invalidationEvents.add(ClientRemovedEvent.create(client));
        this.cache.clientRemoval(realm.getId(), id, client.getClientId(), this.invalidations);
        for (RoleModel role : client.getRoles()) {
            this.roleRemovalInvalidations(role.getId(), role.getName(), client.getId());
        }
        return this.getRealmDelegate().removeClient(id, realm);
    }

    public void close() {
        if (this.realmDelegate != null) {
            this.realmDelegate.close();
        }
        if (this.clientDelegate != null) {
            this.clientDelegate.close();
        }
    }

    public RoleModel addRealmRole(RealmModel realm, String name) {
        return this.addRealmRole(realm, KeycloakModelUtils.generateId(), name);
    }

    public RoleModel addRealmRole(RealmModel realm, String id, String name) {
        RoleModel role = this.getRealmDelegate().addRealmRole(realm, id, name);
        this.addedRole(role.getId(), realm.getId());
        return role;
    }

    public Set<RoleModel> getRealmRoles(RealmModel realm) {
        boolean queryDB;
        String cacheKey = RealmCacheSession.getRolesCacheKey(realm.getId());
        boolean bl = queryDB = this.invalidations.contains(cacheKey) || this.listInvalidations.contains(realm.getId());
        if (queryDB) {
            return this.getRealmDelegate().getRealmRoles(realm);
        }
        RoleListQuery query = this.cache.get(cacheKey, RoleListQuery.class);
        if (query != null) {
            logger.tracev("getRealmRoles cache hit: {0}", (Object)realm.getName());
        }
        if (query == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            Set model = this.getRealmDelegate().getRealmRoles(realm);
            if (model == null) {
                return null;
            }
            HashSet<String> ids = new HashSet<String>();
            for (RoleModel role : model) {
                ids.add(role.getId());
            }
            query = new RoleListQuery(loaded, cacheKey, realm, ids);
            logger.tracev("adding realm roles cache miss: realm {0} key {1}", (Object)realm.getName(), (Object)cacheKey);
            this.cache.addRevisioned(query, this.startupRevision);
            return model;
        }
        HashSet<RoleModel> list = new HashSet<RoleModel>();
        for (String id : query.getRoles()) {
            RoleModel role = this.session.realms().getRoleById(id, realm);
            if (role == null) {
                this.invalidations.add(cacheKey);
                return this.getRealmDelegate().getRealmRoles(realm);
            }
            list.add(role);
        }
        return list;
    }

    public Set<RoleModel> getClientRoles(RealmModel realm, ClientModel client) {
        boolean queryDB;
        String cacheKey = RealmCacheSession.getRolesCacheKey(client.getId());
        boolean bl = queryDB = this.invalidations.contains(cacheKey) || this.listInvalidations.contains(client.getId());
        if (queryDB) {
            return this.getRealmDelegate().getClientRoles(realm, client);
        }
        RoleListQuery query = this.cache.get(cacheKey, RoleListQuery.class);
        if (query != null) {
            logger.tracev("getClientRoles cache hit: {0}", (Object)client.getClientId());
        }
        if (query == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            Set model = this.getRealmDelegate().getClientRoles(realm, client);
            if (model == null) {
                return null;
            }
            HashSet<String> ids = new HashSet<String>();
            for (RoleModel role : model) {
                ids.add(role.getId());
            }
            query = new RoleListQuery(loaded, cacheKey, realm, ids, client.getClientId());
            logger.tracev("adding client roles cache miss: client {0} key {1}", (Object)client.getClientId(), (Object)cacheKey);
            this.cache.addRevisioned(query, this.startupRevision);
            return model;
        }
        HashSet<RoleModel> list = new HashSet<RoleModel>();
        for (String id : query.getRoles()) {
            RoleModel role = this.session.realms().getRoleById(id, realm);
            if (role == null) {
                this.invalidations.add(cacheKey);
                return this.getRealmDelegate().getClientRoles(realm, client);
            }
            list.add(role);
        }
        return list;
    }

    public RoleModel addClientRole(RealmModel realm, ClientModel client, String name) {
        return this.addClientRole(realm, client, KeycloakModelUtils.generateId(), name);
    }

    public RoleModel addClientRole(RealmModel realm, ClientModel client, String id, String name) {
        RoleModel role = this.getRealmDelegate().addClientRole(realm, client, id, name);
        this.addedRole(role.getId(), client.getId());
        return role;
    }

    public RoleModel getRealmRole(RealmModel realm, String name) {
        boolean queryDB;
        String cacheKey = RealmCacheSession.getRoleByNameCacheKey(realm.getId(), name);
        boolean bl = queryDB = this.invalidations.contains(cacheKey) || this.listInvalidations.contains(realm.getId());
        if (queryDB) {
            return this.getRealmDelegate().getRealmRole(realm, name);
        }
        RoleListQuery query = this.cache.get(cacheKey, RoleListQuery.class);
        if (query != null) {
            logger.tracev("getRealmRole cache hit: {0}.{1}", (Object)realm.getName(), (Object)name);
        }
        if (query == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            RoleModel model = this.getRealmDelegate().getRealmRole(realm, name);
            if (model == null) {
                return null;
            }
            query = new RoleListQuery(loaded, cacheKey, realm, model.getId());
            logger.tracev("adding realm role cache miss: client {0} key {1}", (Object)realm.getName(), (Object)cacheKey);
            this.cache.addRevisioned(query, this.startupRevision);
            return model;
        }
        RoleModel role = this.getRoleById(query.getRoles().iterator().next(), realm);
        if (role == null) {
            this.invalidations.add(cacheKey);
            return this.getRealmDelegate().getRealmRole(realm, name);
        }
        return role;
    }

    public RoleModel getClientRole(RealmModel realm, ClientModel client, String name) {
        boolean queryDB;
        String cacheKey = RealmCacheSession.getRoleByNameCacheKey(client.getId(), name);
        boolean bl = queryDB = this.invalidations.contains(cacheKey) || this.listInvalidations.contains(client.getId());
        if (queryDB) {
            return this.getRealmDelegate().getClientRole(realm, client, name);
        }
        RoleListQuery query = this.cache.get(cacheKey, RoleListQuery.class);
        if (query != null) {
            logger.tracev("getClientRole cache hit: {0}.{1}", (Object)client.getClientId(), (Object)name);
        }
        if (query == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            RoleModel model = this.getRealmDelegate().getClientRole(realm, client, name);
            if (model == null) {
                return null;
            }
            query = new RoleListQuery(loaded, cacheKey, realm, model.getId(), client.getClientId());
            logger.tracev("adding client role cache miss: client {0} key {1}", (Object)client.getClientId(), (Object)cacheKey);
            this.cache.addRevisioned(query, this.startupRevision);
            return model;
        }
        RoleModel role = this.getRoleById(query.getRoles().iterator().next(), realm);
        if (role == null) {
            this.invalidations.add(cacheKey);
            return this.getRealmDelegate().getClientRole(realm, client, name);
        }
        return role;
    }

    public boolean removeRole(RealmModel realm, RoleModel role) {
        this.listInvalidations.add(role.getContainer().getId());
        this.invalidateRole(role.getId());
        this.invalidationEvents.add(RoleRemovedEvent.create(role.getId(), role.getName(), role.getContainer().getId()));
        this.roleRemovalInvalidations(role.getId(), role.getName(), role.getContainer().getId());
        return this.getRealmDelegate().removeRole(realm, role);
    }

    public RoleModel getRoleById(String id, RealmModel realm) {
        CachedRole cached = this.cache.get(id, CachedRole.class);
        if (cached != null && !cached.getRealm().equals(realm.getId())) {
            cached = null;
        }
        if (cached == null) {
            Long loaded = this.cache.getCurrentRevision(id);
            RoleModel model = this.getRealmDelegate().getRoleById(id, realm);
            if (model == null) {
                return null;
            }
            if (this.invalidations.contains(id)) {
                return model;
            }
            cached = model.isClientRole() ? new CachedClientRole(loaded, model.getContainerId(), model, realm) : new CachedRealmRole(loaded, model, realm);
            this.cache.addRevisioned(cached, this.startupRevision);
        } else {
            if (this.invalidations.contains(id)) {
                return this.getRealmDelegate().getRoleById(id, realm);
            }
            if (this.managedRoles.containsKey(id)) {
                return this.managedRoles.get(id);
            }
        }
        RoleAdapter adapter = new RoleAdapter(cached, this, realm);
        this.managedRoles.put(id, adapter);
        return adapter;
    }

    public GroupModel getGroupById(String id, RealmModel realm) {
        CachedGroup cached = this.cache.get(id, CachedGroup.class);
        if (cached != null && !cached.getRealm().equals(realm.getId())) {
            cached = null;
        }
        if (cached == null) {
            Long loaded = this.cache.getCurrentRevision(id);
            GroupModel model = this.getRealmDelegate().getGroupById(id, realm);
            if (model == null) {
                return null;
            }
            if (this.invalidations.contains(id)) {
                return model;
            }
            cached = new CachedGroup(loaded, realm, model);
            this.cache.addRevisioned(cached, this.startupRevision);
        } else {
            if (this.invalidations.contains(id)) {
                return this.getRealmDelegate().getGroupById(id, realm);
            }
            if (this.managedGroups.containsKey(id)) {
                return this.managedGroups.get(id);
            }
        }
        GroupAdapter adapter = new GroupAdapter(cached, this, this.session, realm);
        this.managedGroups.put(id, adapter);
        return adapter;
    }

    public void moveGroup(RealmModel realm, GroupModel group, GroupModel toParent) {
        this.invalidateGroup(group.getId(), realm.getId(), true);
        if (toParent != null) {
            this.invalidateGroup(group.getId(), realm.getId(), false);
        }
        this.listInvalidations.add(realm.getId());
        this.invalidationEvents.add(GroupMovedEvent.create(group, toParent, realm.getId()));
        this.getRealmDelegate().moveGroup(realm, group, toParent);
    }

    public List<GroupModel> getGroups(RealmModel realm) {
        boolean queryDB;
        String cacheKey = RealmCacheSession.getGroupsQueryCacheKey(realm.getId());
        boolean bl = queryDB = this.invalidations.contains(cacheKey) || this.listInvalidations.contains(realm.getId());
        if (queryDB) {
            return this.getRealmDelegate().getGroups(realm);
        }
        GroupListQuery query = this.cache.get(cacheKey, GroupListQuery.class);
        if (query != null) {
            logger.tracev("getGroups cache hit: {0}", (Object)realm.getName());
        }
        if (query == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            List model = this.getRealmDelegate().getGroups(realm);
            if (model == null) {
                return null;
            }
            HashSet<String> ids = new HashSet<String>();
            for (GroupModel client : model) {
                ids.add(client.getId());
            }
            query = new GroupListQuery(loaded, cacheKey, realm, ids);
            logger.tracev("adding realm getGroups cache miss: realm {0} key {1}", (Object)realm.getName(), (Object)cacheKey);
            this.cache.addRevisioned(query, this.startupRevision);
            return model;
        }
        LinkedList<GroupModel> list = new LinkedList<GroupModel>();
        for (String id : query.getGroups()) {
            GroupModel group = this.session.realms().getGroupById(id, realm);
            if (group == null) {
                this.invalidations.add(cacheKey);
                return this.getRealmDelegate().getGroups(realm);
            }
            list.add(group);
        }
        list.sort(Comparator.comparing(GroupModel::getName));
        return list;
    }

    public Long getGroupsCount(RealmModel realm, Boolean onlyTopGroups) {
        return this.getRealmDelegate().getGroupsCount(realm, onlyTopGroups);
    }

    public Long getGroupsCountByNameContaining(RealmModel realm, String search) {
        return this.getRealmDelegate().getGroupsCountByNameContaining(realm, search);
    }

    public List<GroupModel> getTopLevelGroups(RealmModel realm) {
        boolean queryDB;
        String cacheKey = RealmCacheSession.getTopGroupsQueryCacheKey(realm.getId());
        boolean bl = queryDB = this.invalidations.contains(cacheKey) || this.listInvalidations.contains(realm.getId());
        if (queryDB) {
            return this.getRealmDelegate().getTopLevelGroups(realm);
        }
        GroupListQuery query = this.cache.get(cacheKey, GroupListQuery.class);
        if (query != null) {
            logger.tracev("getTopLevelGroups cache hit: {0}", (Object)realm.getName());
        }
        if (query == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            List model = this.getRealmDelegate().getTopLevelGroups(realm);
            if (model == null) {
                return null;
            }
            HashSet<String> ids = new HashSet<String>();
            for (GroupModel client : model) {
                ids.add(client.getId());
            }
            query = new GroupListQuery(loaded, cacheKey, realm, ids);
            logger.tracev("adding realm getTopLevelGroups cache miss: realm {0} key {1}", (Object)realm.getName(), (Object)cacheKey);
            this.cache.addRevisioned(query, this.startupRevision);
            return model;
        }
        LinkedList<GroupModel> list = new LinkedList<GroupModel>();
        for (String id : query.getGroups()) {
            GroupModel group = this.session.realms().getGroupById(id, realm);
            if (group == null) {
                this.invalidations.add(cacheKey);
                return this.getRealmDelegate().getTopLevelGroups(realm);
            }
            list.add(group);
        }
        list.sort(Comparator.comparing(GroupModel::getName));
        return list;
    }

    public List<GroupModel> getTopLevelGroups(RealmModel realm, Integer first, Integer max) {
        boolean queryDB;
        String cacheKey = RealmCacheSession.getTopGroupsQueryCacheKey(realm.getId() + first + max);
        boolean bl = queryDB = this.invalidations.contains(cacheKey) || this.listInvalidations.contains(realm.getId() + first + max);
        if (queryDB) {
            return this.getRealmDelegate().getTopLevelGroups(realm, first, max);
        }
        GroupListQuery query = this.cache.get(cacheKey, GroupListQuery.class);
        if (Objects.nonNull(query)) {
            logger.tracev("getTopLevelGroups cache hit: {0}", (Object)realm.getName());
        }
        if (Objects.isNull(query)) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            List model = this.getRealmDelegate().getTopLevelGroups(realm, first, max);
            if (model == null) {
                return null;
            }
            HashSet<String> ids = new HashSet<String>();
            for (GroupModel client : model) {
                ids.add(client.getId());
            }
            query = new GroupListQuery(loaded, cacheKey, realm, ids);
            logger.tracev("adding realm getTopLevelGroups cache miss: realm {0} key {1}", (Object)realm.getName(), (Object)cacheKey);
            this.cache.addRevisioned(query, this.startupRevision);
            return model;
        }
        LinkedList<GroupModel> list = new LinkedList<GroupModel>();
        for (String id : query.getGroups()) {
            GroupModel group = this.session.realms().getGroupById(id, realm);
            if (Objects.isNull(group)) {
                this.invalidations.add(cacheKey);
                return this.getRealmDelegate().getTopLevelGroups(realm);
            }
            list.add(group);
        }
        list.sort(Comparator.comparing(GroupModel::getName));
        return list;
    }

    public List<GroupModel> searchForGroupByName(RealmModel realm, String search, Integer first, Integer max) {
        return this.getRealmDelegate().searchForGroupByName(realm, search, first, max);
    }

    public boolean removeGroup(RealmModel realm, GroupModel group) {
        this.invalidateGroup(group.getId(), realm.getId(), true);
        this.listInvalidations.add(realm.getId());
        this.cache.groupQueriesInvalidations(realm.getId(), this.invalidations);
        if (group.getParentId() != null) {
            this.invalidateGroup(group.getParentId(), realm.getId(), false);
        }
        this.invalidationEvents.add(GroupRemovedEvent.create(group, realm.getId()));
        return this.getRealmDelegate().removeGroup(realm, group);
    }

    public GroupModel createGroup(RealmModel realm, String name) {
        GroupModel group = this.getRealmDelegate().createGroup(realm, name);
        return this.groupAdded(realm, group);
    }

    private GroupModel groupAdded(RealmModel realm, GroupModel group) {
        this.listInvalidations.add(realm.getId());
        this.cache.groupQueriesInvalidations(realm.getId(), this.invalidations);
        this.invalidations.add(group.getId());
        this.invalidationEvents.add(GroupAddedEvent.create(group.getId(), realm.getId()));
        return group;
    }

    public GroupModel createGroup(RealmModel realm, String id, String name) {
        GroupModel group = this.getRealmDelegate().createGroup(realm, id, name);
        return this.groupAdded(realm, group);
    }

    public void addTopLevelGroup(RealmModel realm, GroupModel subGroup) {
        this.invalidateGroup(subGroup.getId(), realm.getId(), true);
        if (subGroup.getParentId() != null) {
            this.invalidateGroup(subGroup.getParentId(), realm.getId(), false);
        }
        this.addGroupEventIfAbsent(GroupMovedEvent.create(subGroup, null, realm.getId()));
        this.getRealmDelegate().addTopLevelGroup(realm, subGroup);
    }

    private void addGroupEventIfAbsent(InvalidationEvent eventToAdd) {
        String groupId = eventToAdd.getId();
        boolean eventAlreadyExists = this.invalidationEvents.stream().anyMatch(event -> event.getId().equals(groupId) && (event instanceof GroupAddedEvent || event instanceof GroupMovedEvent || event instanceof GroupRemovedEvent));
        if (!eventAlreadyExists) {
            this.invalidationEvents.add(eventToAdd);
        }
    }

    public ClientModel getClientById(String id, RealmModel realm) {
        CachedClient cached = this.cache.get(id, CachedClient.class);
        if (cached != null && !cached.getRealm().equals(realm.getId())) {
            cached = null;
        }
        if (cached != null) {
            logger.tracev("client by id cache hit: {0}", (Object)cached.getClientId());
        }
        if (cached == null) {
            Long loaded = this.cache.getCurrentRevision(id);
            ClientModel model = this.getClientDelegate().getClientById(id, realm);
            if (model == null) {
                return null;
            }
            ClientModel adapter = this.cacheClient(realm, model, loaded);
            this.managedApplications.put(id, adapter);
            return adapter;
        }
        if (this.invalidations.contains(id)) {
            return this.getRealmDelegate().getClientById(id, realm);
        }
        if (this.managedApplications.containsKey(id)) {
            return this.managedApplications.get(id);
        }
        ClientModel adapter = this.validateCache(realm, cached);
        this.managedApplications.put(id, adapter);
        return adapter;
    }

    protected ClientModel cacheClient(RealmModel realm, ClientModel delegate, Long revision) {
        if (this.invalidations.contains(delegate.getId())) {
            return delegate;
        }
        StorageId storageId = new StorageId(delegate.getId());
        CachedClient cached = null;
        ClientAdapter adapter = null;
        if (!storageId.isLocal()) {
            ComponentModel component = realm.getComponent(storageId.getProviderId());
            ClientStorageProviderModel model = new ClientStorageProviderModel(component);
            if (!model.isEnabled()) {
                return delegate;
            }
            CacheableStorageProviderModel.CachePolicy policy = model.getCachePolicy();
            if (policy != null && policy == CacheableStorageProviderModel.CachePolicy.NO_CACHE) {
                return delegate;
            }
            cached = new CachedClient(revision, realm, delegate);
            adapter = new ClientAdapter(realm, cached, this);
            long lifespan = model.getLifespan();
            if (lifespan > 0L) {
                this.cache.addRevisioned(cached, this.startupRevision, lifespan);
            } else {
                this.cache.addRevisioned(cached, this.startupRevision);
            }
        } else {
            cached = new CachedClient(revision, realm, delegate);
            adapter = new ClientAdapter(realm, cached, this);
            this.cache.addRevisioned(cached, this.startupRevision);
        }
        return adapter;
    }

    protected ClientModel validateCache(RealmModel realm, CachedClient cached) {
        ComponentModel component;
        ClientStorageProviderModel model;
        if (!realm.getId().equals(cached.getRealm())) {
            return null;
        }
        StorageId storageId = new StorageId(cached.getId());
        if (!storageId.isLocal() && (model = new ClientStorageProviderModel(component = realm.getComponent(storageId.getProviderId()))).shouldInvalidate((CachedObject)cached)) {
            this.registerClientInvalidation(cached.getId(), cached.getClientId(), realm.getId());
            return this.getClientDelegate().getClientById(cached.getId(), realm);
        }
        ClientAdapter adapter = new ClientAdapter(realm, cached, this);
        return adapter;
    }

    public ClientModel getClientByClientId(String clientId, RealmModel realm) {
        String cacheKey = RealmCacheSession.getClientByClientIdCacheKey(clientId, realm.getId());
        ClientListQuery query = this.cache.get(cacheKey, ClientListQuery.class);
        String id = null;
        if (query != null) {
            logger.tracev("client by name cache hit: {0}", (Object)clientId);
        }
        if (query == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            ClientModel model = this.getClientDelegate().getClientByClientId(clientId, realm);
            if (model == null) {
                return null;
            }
            if (this.invalidations.contains(model.getId())) {
                return model;
            }
            id = model.getId();
            query = new ClientListQuery(loaded, cacheKey, realm, id);
            logger.tracev("adding client by name cache miss: {0}", (Object)clientId);
            this.cache.addRevisioned(query, this.startupRevision);
        } else {
            if (this.invalidations.contains(cacheKey)) {
                return this.getClientDelegate().getClientByClientId(clientId, realm);
            }
            id = query.getClients().iterator().next();
            if (this.invalidations.contains(id)) {
                return this.getClientDelegate().getClientByClientId(clientId, realm);
            }
        }
        return this.getClientById(id, realm);
    }

    static String getClientByClientIdCacheKey(String clientId, String realmId) {
        return realmId + ".client.query.by.clientId." + clientId;
    }

    public ClientScopeModel getClientScopeById(String id, RealmModel realm) {
        CachedClientScope cached = this.cache.get(id, CachedClientScope.class);
        if (cached != null && !cached.getRealm().equals(realm.getId())) {
            cached = null;
        }
        if (cached == null) {
            Long loaded = this.cache.getCurrentRevision(id);
            ClientScopeModel model = this.getRealmDelegate().getClientScopeById(id, realm);
            if (model == null) {
                return null;
            }
            if (this.invalidations.contains(id)) {
                return model;
            }
            cached = new CachedClientScope(loaded, realm, model);
            this.cache.addRevisioned(cached, this.startupRevision);
        } else {
            if (this.invalidations.contains(id)) {
                return this.getRealmDelegate().getClientScopeById(id, realm);
            }
            if (this.managedClientScopes.containsKey(id)) {
                return this.managedClientScopes.get(id);
            }
        }
        ClientScopeAdapter adapter = new ClientScopeAdapter(realm, cached, this);
        this.managedClientScopes.put(id, adapter);
        return adapter;
    }

    public ClientInitialAccessModel createClientInitialAccessModel(RealmModel realm, int expiration, int count) {
        return this.getRealmDelegate().createClientInitialAccessModel(realm, expiration, count);
    }

    public ClientInitialAccessModel getClientInitialAccessModel(RealmModel realm, String id) {
        return this.getRealmDelegate().getClientInitialAccessModel(realm, id);
    }

    public void removeClientInitialAccessModel(RealmModel realm, String id) {
        this.getRealmDelegate().removeClientInitialAccessModel(realm, id);
    }

    public List<ClientInitialAccessModel> listClientInitialAccess(RealmModel realm) {
        return this.getRealmDelegate().listClientInitialAccess(realm);
    }

    public void removeExpiredClientInitialAccess() {
        this.getRealmDelegate().removeExpiredClientInitialAccess();
    }

    public void decreaseRemainingCount(RealmModel realm, ClientInitialAccessModel clientInitialAccess) {
        this.getRealmDelegate().decreaseRemainingCount(realm, clientInitialAccess);
    }
}

