/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf.context;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.bnf.context.DbColumn;
import org.h2.bnf.context.DbSchema;
import org.h2.util.New;

public class DbTableOrView {
    private final DbSchema schema;
    private final String name;
    private final String quotedName;
    private final boolean isView;
    private DbColumn[] columns;

    public DbTableOrView(DbSchema dbSchema, ResultSet resultSet) throws SQLException {
        this.schema = dbSchema;
        this.name = resultSet.getString("TABLE_NAME");
        String string = resultSet.getString("TABLE_TYPE");
        this.isView = "VIEW".equals(string);
        this.quotedName = dbSchema.getContents().quoteIdentifier(this.name);
    }

    public DbSchema getSchema() {
        return this.schema;
    }

    public DbColumn[] getColumns() {
        return this.columns;
    }

    public String getName() {
        return this.name;
    }

    public boolean isView() {
        return this.isView;
    }

    public String getQuotedName() {
        return this.quotedName;
    }

    public void readColumns(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = databaseMetaData.getColumns(null, this.schema.name, this.name, null);
        ArrayList<DbColumn> arrayList = New.arrayList();
        while (resultSet.next()) {
            DbColumn dbColumn = DbColumn.getColumn(this.schema.getContents(), resultSet);
            arrayList.add(dbColumn);
        }
        resultSet.close();
        this.columns = new DbColumn[arrayList.size()];
        arrayList.toArray(this.columns);
    }
}

