/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.job.repository;

import java.util.Properties;
import org.jberet.repository.InMemoryRepository;
import org.jberet.repository.JdbcRepository;
import org.jberet.repository.JobRepository;
import org.jboss.as.ee.component.EEModuleDescription;
import org.wildfly.extension.batch.job.repository.JobRepositoryType;

public class JobRepositoryFactory {
    public static final String JNDI_NAME = "datasource-jndi";
    private static final JobRepositoryFactory INSTANCE = new JobRepositoryFactory();
    private volatile JobRepositoryType type;
    private volatile String jndiName;

    private JobRepositoryFactory() {
    }

    public static JobRepositoryFactory getInstance() {
        return INSTANCE;
    }

    public JobRepository getJobRepository(EEModuleDescription moduleDescription) {
        JobRepositoryType type = this.type;
        if (JobRepositoryType.JDBC == type) {
            String jndiName = this.jndiName;
            if (jndiName == null) {
                jndiName = moduleDescription.getDefaultResourceJndiNames().getDataSource();
            }
            Properties configProperties = new Properties();
            configProperties.setProperty(JNDI_NAME, jndiName);
            return JdbcRepository.create((Properties)configProperties);
        }
        return InMemoryRepository.getInstance();
    }

    public boolean requiresJndiName() {
        return JobRepositoryType.JDBC == this.type && this.jndiName == null;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void setJobRepositoryType(String jobRepositoryType) {
        this.setJobRepositoryType(JobRepositoryType.of(jobRepositoryType));
    }

    public void setJobRepositoryType(JobRepositoryType type) {
        this.type = type;
    }
}

