/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.entities;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.keycloak.models.sessions.infinispan.util.KeycloakMarshallUtil;
import org.keycloak.sessions.CommonClientSessionModel;

@SerializeWith(value=ExternalizerImpl.class)
public class AuthenticationSessionEntity
implements Serializable {
    private String clientUUID;
    private String authUserId;
    private String redirectUri;
    private String action;
    private Set<String> clientScopes;
    private Map<String, CommonClientSessionModel.ExecutionStatus> executionStatus = new ConcurrentHashMap<String, CommonClientSessionModel.ExecutionStatus>();
    private String protocol;
    private Map<String, String> clientNotes;
    private Map<String, String> authNotes;
    private Set<String> requiredActions = new ConcurrentHashSet();
    private Map<String, String> userSessionNotes;

    public AuthenticationSessionEntity() {
    }

    public AuthenticationSessionEntity(String clientUUID, String authUserId, String redirectUri, String action, Set<String> clientScopes, Map<String, CommonClientSessionModel.ExecutionStatus> executionStatus, String protocol, Map<String, String> clientNotes, Map<String, String> authNotes, Set<String> requiredActions, Map<String, String> userSessionNotes) {
        this.clientUUID = clientUUID;
        this.authUserId = authUserId;
        this.redirectUri = redirectUri;
        this.action = action;
        this.clientScopes = clientScopes;
        this.executionStatus = executionStatus;
        this.protocol = protocol;
        this.clientNotes = clientNotes;
        this.authNotes = authNotes;
        this.requiredActions = requiredActions;
        this.userSessionNotes = userSessionNotes;
    }

    public String getClientUUID() {
        return this.clientUUID;
    }

    public void setClientUUID(String clientUUID) {
        this.clientUUID = clientUUID;
    }

    public String getAuthUserId() {
        return this.authUserId;
    }

    public void setAuthUserId(String authUserId) {
        this.authUserId = authUserId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Set<String> getClientScopes() {
        return this.clientScopes;
    }

    public void setClientScopes(Set<String> clientScopes) {
        this.clientScopes = clientScopes;
    }

    public Map<String, CommonClientSessionModel.ExecutionStatus> getExecutionStatus() {
        return this.executionStatus;
    }

    public void setExecutionStatus(Map<String, CommonClientSessionModel.ExecutionStatus> executionStatus) {
        this.executionStatus = executionStatus;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Map<String, String> getClientNotes() {
        return this.clientNotes;
    }

    public void setClientNotes(Map<String, String> clientNotes) {
        this.clientNotes = clientNotes;
    }

    public Set<String> getRequiredActions() {
        return this.requiredActions;
    }

    public void setRequiredActions(Set<String> requiredActions) {
        this.requiredActions = requiredActions;
    }

    public Map<String, String> getUserSessionNotes() {
        return this.userSessionNotes;
    }

    public void setUserSessionNotes(Map<String, String> userSessionNotes) {
        this.userSessionNotes = userSessionNotes;
    }

    public Map<String, String> getAuthNotes() {
        return this.authNotes;
    }

    public void setAuthNotes(Map<String, String> authNotes) {
        this.authNotes = authNotes;
    }

    public static class ExternalizerImpl
    implements Externalizer<AuthenticationSessionEntity> {
        private static final int VERSION_1 = 1;
        public static final ExternalizerImpl INSTANCE = new ExternalizerImpl();
        public static final Externalizer<CommonClientSessionModel.ExecutionStatus> EXECUTION_STATUS_EXT = new Externalizer<CommonClientSessionModel.ExecutionStatus>(){

            public void writeObject(ObjectOutput output, CommonClientSessionModel.ExecutionStatus e) throws IOException {
                MarshallUtil.marshallEnum((Enum)e, (ObjectOutput)output);
            }

            public CommonClientSessionModel.ExecutionStatus readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return (CommonClientSessionModel.ExecutionStatus)MarshallUtil.unmarshallEnum((ObjectInput)input, x$0 -> ExternalizerImpl.fromOrdinal(x$0));
            }
        };

        private static CommonClientSessionModel.ExecutionStatus fromOrdinal(int ordinal) {
            CommonClientSessionModel.ExecutionStatus[] values = CommonClientSessionModel.ExecutionStatus.values();
            return ordinal < 0 || ordinal >= values.length ? null : values[ordinal];
        }

        public void writeObject(ObjectOutput output, AuthenticationSessionEntity value) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)value.clientUUID, (ObjectOutput)output);
            MarshallUtil.marshallString((String)value.authUserId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)value.redirectUri, (ObjectOutput)output);
            MarshallUtil.marshallString((String)value.action, (ObjectOutput)output);
            KeycloakMarshallUtil.writeCollection(value.clientScopes, KeycloakMarshallUtil.STRING_EXT, output);
            KeycloakMarshallUtil.writeMap(value.executionStatus, KeycloakMarshallUtil.STRING_EXT, EXECUTION_STATUS_EXT, output);
            MarshallUtil.marshallString((String)value.protocol, (ObjectOutput)output);
            KeycloakMarshallUtil.writeMap(value.clientNotes, KeycloakMarshallUtil.STRING_EXT, KeycloakMarshallUtil.STRING_EXT, output);
            KeycloakMarshallUtil.writeMap(value.authNotes, KeycloakMarshallUtil.STRING_EXT, KeycloakMarshallUtil.STRING_EXT, output);
            KeycloakMarshallUtil.writeCollection(value.requiredActions, KeycloakMarshallUtil.STRING_EXT, output);
            KeycloakMarshallUtil.writeMap(value.userSessionNotes, KeycloakMarshallUtil.STRING_EXT, KeycloakMarshallUtil.STRING_EXT, output);
        }

        public AuthenticationSessionEntity readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public AuthenticationSessionEntity readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            return new AuthenticationSessionEntity(MarshallUtil.unmarshallString((ObjectInput)input), MarshallUtil.unmarshallString((ObjectInput)input), MarshallUtil.unmarshallString((ObjectInput)input), MarshallUtil.unmarshallString((ObjectInput)input), (Set)KeycloakMarshallUtil.readCollection(input, KeycloakMarshallUtil.STRING_EXT, size -> new ConcurrentHashSet()), (Map<String, CommonClientSessionModel.ExecutionStatus>)KeycloakMarshallUtil.readMap(input, KeycloakMarshallUtil.STRING_EXT, EXECUTION_STATUS_EXT, size -> new ConcurrentHashMap(size)), MarshallUtil.unmarshallString((ObjectInput)input), (Map<String, String>)KeycloakMarshallUtil.readMap(input, KeycloakMarshallUtil.STRING_EXT, KeycloakMarshallUtil.STRING_EXT, size -> new ConcurrentHashMap(size)), (Map<String, String>)KeycloakMarshallUtil.readMap(input, KeycloakMarshallUtil.STRING_EXT, KeycloakMarshallUtil.STRING_EXT, size -> new ConcurrentHashMap(size)), (Set)KeycloakMarshallUtil.readCollection(input, KeycloakMarshallUtil.STRING_EXT, size -> new ConcurrentHashSet()), (Map<String, String>)KeycloakMarshallUtil.readMap(input, KeycloakMarshallUtil.STRING_EXT, KeycloakMarshallUtil.STRING_EXT, size -> new ConcurrentHashMap(size)));
        }
    }
}

