/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.classhierarchy.ClassHierarchyHelper;
import org.hibernate.validator.internal.util.classhierarchy.Filter;
import org.hibernate.validator.spi.group.DefaultGroupSequenceProvider;

public abstract class MetaDataProviderKeyedByClassName
implements MetaDataProvider {
    protected final ConstraintHelper constraintHelper;
    private final Map<String, BeanConfiguration<?>> configuredBeans;

    public MetaDataProviderKeyedByClassName(ConstraintHelper constraintHelper, Map<String, BeanConfiguration<?>> configuredBeans) {
        this.constraintHelper = constraintHelper;
        this.configuredBeans = Collections.unmodifiableMap(configuredBeans);
    }

    @Override
    public <T> List<BeanConfiguration<? super T>> getBeanConfigurationForHierarchy(Class<T> beanClass) {
        ArrayList<BeanConfiguration<T>> configurations = CollectionHelper.newArrayList();
        for (Class<T> clazz : ClassHierarchyHelper.getHierarchy(beanClass, new Filter[0])) {
            BeanConfiguration<T> configuration = this.getBeanConfiguration(clazz);
            if (configuration == null) continue;
            configurations.add(configuration);
        }
        return configurations;
    }

    protected <T> BeanConfiguration<T> getBeanConfiguration(Class<T> beanClass) {
        Contracts.assertNotNull(beanClass);
        return this.configuredBeans.get(beanClass.getName());
    }

    protected static <T> BeanConfiguration<T> createBeanConfiguration(ConfigurationSource source, Class<T> beanClass, Set<? extends ConstrainedElement> constrainedElements, List<Class<?>> defaultGroupSequence, DefaultGroupSequenceProvider<? super T> defaultGroupSequenceProvider) {
        return new BeanConfiguration<T>(source, beanClass, constrainedElements, defaultGroupSequence, defaultGroupSequenceProvider);
    }
}

