/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jndi;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jndi.LazyCreateContext;
import org.apache.activemq.artemis.jndi.ReadOnlyContext;
import org.apache.activemq.artemis.uri.ConnectionFactoryParser;

public class ActiveMQInitialContextFactory
implements InitialContextFactory {
    public static final String REFRESH_TIMEOUT = "refreshTimeout";
    public static final String DISCOVERY_INITIAL_WAIT_TIMEOUT = "discoveryInitialWaitTimeout";
    public static final String DYNAMIC_QUEUE_CONTEXT = "dynamicQueues";
    public static final String DYNAMIC_TOPIC_CONTEXT = "dynamicTopics";
    private String connectionFactoryPrefix = "connectionFactory.";
    private String queuePrefix = "queue.";
    private String topicPrefix = "topic.";

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        ConcurrentHashMap<String, Object> data = new ConcurrentHashMap<String, Object>();
        for (Map.Entry<?, ?> entry : environment.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.connectionFactoryPrefix)) continue;
            String jndiName = key.substring(this.connectionFactoryPrefix.length());
            try {
                ConnectionFactory factory = this.createConnectionFactory((String)environment.get(key), jndiName);
                data.put(jndiName, factory);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NamingException("Invalid broker URL");
            }
        }
        this.createQueues(data, environment);
        this.createTopics(data, environment);
        data.put(DYNAMIC_QUEUE_CONTEXT, new LazyCreateContext(){
            private static final long serialVersionUID = 6503881346214855588L;

            @Override
            protected Object createEntry(String name) {
                return ActiveMQJMSClient.createQueue(name);
            }
        });
        data.put(DYNAMIC_TOPIC_CONTEXT, new LazyCreateContext(){
            private static final long serialVersionUID = 2019166796234979615L;

            @Override
            protected Object createEntry(String name) {
                return ActiveMQJMSClient.createTopic(name);
            }
        });
        return this.createContext(environment, data);
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    public void setQueuePrefix(String queuePrefix) {
        this.queuePrefix = queuePrefix;
    }

    protected ReadOnlyContext createContext(Hashtable<?, ?> environment, Map<String, Object> data) {
        return new ReadOnlyContext(environment, data);
    }

    protected void createQueues(Map<String, Object> data, Hashtable<?, ?> environment) {
        for (Map.Entry<?, ?> entry : environment.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.queuePrefix)) continue;
            String jndiName = key.substring(this.queuePrefix.length());
            data.put(jndiName, this.createQueue(entry.getValue().toString()));
        }
    }

    protected void createTopics(Map<String, Object> data, Hashtable<?, ?> environment) {
        for (Map.Entry<?, ?> entry : environment.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.topicPrefix)) continue;
            String jndiName = key.substring(this.topicPrefix.length());
            data.put(jndiName, this.createTopic(entry.getValue().toString()));
        }
    }

    protected Queue createQueue(String name) {
        return ActiveMQJMSClient.createQueue(name);
    }

    protected Topic createTopic(String name) {
        return ActiveMQJMSClient.createTopic(name);
    }

    protected ConnectionFactory createConnectionFactory(String uri, String name) throws Exception {
        ConnectionFactoryParser parser = new ConnectionFactoryParser();
        return (ConnectionFactory)parser.newObject(parser.expandURI(uri), name);
    }
}

