/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import twitter4j.HttpResponse;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.Location;
import twitter4j.LocationJSONImpl;
import twitter4j.ParseUtil;
import twitter4j.ResponseList;
import twitter4j.ResponseListImpl;
import twitter4j.Trend;
import twitter4j.TrendJSONImpl;
import twitter4j.Trends;
import twitter4j.TwitterException;
import twitter4j.TwitterObjectFactory;
import twitter4j.TwitterResponseImpl;
import twitter4j.conf.Configuration;

final class TrendsJSONImpl
extends TwitterResponseImpl
implements Trends,
Serializable {
    private static final long serialVersionUID = 2054973282133379835L;
    private Date asOf;
    private Date trendAt;
    private Trend[] trends;
    private Location location;

    @Override
    public int compareTo(Trends that) {
        return this.trendAt.compareTo(that.getTrendAt());
    }

    TrendsJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        super(res);
        this.init(res.asString(), conf.isJSONStoreEnabled());
        if (conf.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
            TwitterObjectFactory.registerJSONObject(this, res.asString());
        }
    }

    TrendsJSONImpl(String jsonStr) throws TwitterException {
        this(jsonStr, false);
    }

    TrendsJSONImpl(String jsonStr, boolean storeJSON) throws TwitterException {
        this.init(jsonStr, storeJSON);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void init(String jsonStr, boolean storeJSON) throws TwitterException {
        try {
            JSONObject json;
            JSONArray array;
            if (jsonStr.startsWith("[")) {
                array = new JSONArray(jsonStr);
                if (array.length() <= 0) throw new TwitterException("No trends found on the specified woeid");
                json = array.getJSONObject(0);
            } else {
                json = new JSONObject(jsonStr);
            }
            this.asOf = ParseUtil.parseTrendsDate(json.getString("as_of"));
            this.location = TrendsJSONImpl.extractLocation(json, storeJSON);
            array = json.getJSONArray("trends");
            this.trendAt = this.asOf;
            this.trends = TrendsJSONImpl.jsonArrayToTrendArray(array, storeJSON);
            return;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage(), jsone);
        }
    }

    TrendsJSONImpl(Date asOf, Location location, Date trendAt, Trend[] trends) {
        this.asOf = asOf;
        this.location = location;
        this.trendAt = trendAt;
        this.trends = trends;
    }

    static ResponseList<Trends> createTrendsList(HttpResponse res, boolean storeJSON) throws TwitterException {
        JSONObject json = res.asJSONObject();
        try {
            Date asOf = ParseUtil.parseTrendsDate(json.getString("as_of"));
            JSONObject trendsJson = json.getJSONObject("trends");
            Location location = TrendsJSONImpl.extractLocation(json, storeJSON);
            ResponseListImpl<Trends> trends = new ResponseListImpl<Trends>(trendsJson.length(), res);
            Iterator ite = trendsJson.keys();
            while (ite.hasNext()) {
                String key = (String)ite.next();
                JSONArray array = trendsJson.getJSONArray(key);
                Trend[] trendsArray = TrendsJSONImpl.jsonArrayToTrendArray(array, storeJSON);
                if (key.length() == 19) {
                    trends.add(new TrendsJSONImpl(asOf, location, ParseUtil.getDate(key, "yyyy-MM-dd HH:mm:ss"), trendsArray));
                    continue;
                }
                if (key.length() == 16) {
                    trends.add(new TrendsJSONImpl(asOf, location, ParseUtil.getDate(key, "yyyy-MM-dd HH:mm"), trendsArray));
                    continue;
                }
                if (key.length() != 10) continue;
                trends.add(new TrendsJSONImpl(asOf, location, ParseUtil.getDate(key, "yyyy-MM-dd"), trendsArray));
            }
            Collections.sort(trends);
            return trends;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage() + ":" + res.asString(), jsone);
        }
    }

    private static Location extractLocation(JSONObject json, boolean storeJSON) throws TwitterException {
        ResponseList<Location> locations;
        if (json.isNull("locations")) {
            return null;
        }
        try {
            locations = LocationJSONImpl.createLocationList(json.getJSONArray("locations"), storeJSON);
        }
        catch (JSONException e) {
            throw new AssertionError((Object)"locations can't be null");
        }
        Location location = 0 != locations.size() ? (Location)locations.get(0) : null;
        return location;
    }

    private static Trend[] jsonArrayToTrendArray(JSONArray array, boolean storeJSON) throws JSONException {
        Trend[] trends = new Trend[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            JSONObject trend = array.getJSONObject(i);
            trends[i] = new TrendJSONImpl(trend, storeJSON);
        }
        return trends;
    }

    @Override
    public Trend[] getTrends() {
        return this.trends;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public Date getAsOf() {
        return this.asOf;
    }

    @Override
    public Date getTrendAt() {
        return this.trendAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Trends)) {
            return false;
        }
        Trends trends1 = (Trends)o;
        if (this.asOf != null ? !this.asOf.equals(trends1.getAsOf()) : trends1.getAsOf() != null) {
            return false;
        }
        if (this.trendAt != null ? !this.trendAt.equals(trends1.getTrendAt()) : trends1.getTrendAt() != null) {
            return false;
        }
        return Arrays.equals(this.trends, trends1.getTrends());
    }

    public int hashCode() {
        int result = this.asOf != null ? this.asOf.hashCode() : 0;
        result = 31 * result + (this.trendAt != null ? this.trendAt.hashCode() : 0);
        result = 31 * result + (this.trends != null ? Arrays.hashCode(this.trends) : 0);
        return result;
    }

    public String toString() {
        return "TrendsJSONImpl{asOf=" + this.asOf + ", trendAt=" + this.trendAt + ", trends=" + (this.trends == null ? null : Arrays.asList(this.trends)) + '}';
    }
}

