/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.spi;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.property.access.internal.AbstractFieldSerialForm;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccessException;

public class GetterFieldImpl
implements Getter {
    private final Class containerClass;
    private final String propertyName;
    private final Field field;

    public GetterFieldImpl(Class containerClass, String propertyName, Field field) {
        this.containerClass = containerClass;
        this.propertyName = propertyName;
        this.field = field;
    }

    @Override
    public Object get(Object owner) {
        try {
            return this.field.get(owner);
        }
        catch (Exception e) {
            throw new PropertyAccessException(String.format(Locale.ROOT, "Error accessing field [%s] by reflection for persistent property [%s#%s] : %s", this.field.toGenericString(), this.containerClass.getName(), this.propertyName, owner), e);
        }
    }

    @Override
    public Object getForInsert(Object owner, Map mergeMap, SessionImplementor session) {
        return this.get(owner);
    }

    @Override
    public Class getReturnType() {
        return this.field.getType();
    }

    @Override
    public Member getMember() {
        return this.field;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Method getMethod() {
        return null;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerialForm(this.containerClass, this.propertyName, this.field);
    }

    private static class SerialForm
    extends AbstractFieldSerialForm
    implements Serializable {
        private final Class containerClass;
        private final String propertyName;

        private SerialForm(Class containerClass, String propertyName, Field field) {
            super(field);
            this.containerClass = containerClass;
            this.propertyName = propertyName;
        }

        private Object readResolve() {
            return new GetterFieldImpl(this.containerClass, this.propertyName, this.resolveField());
        }
    }
}

