/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.csiv2;

import com.sun.corba.se.impl.encoding.CDRInputStream;
import com.sun.corba.se.impl.encoding.EncapsInputStream;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.TaggedComponent;
import com.sun.corba.se.spi.ior.iiop.AlternateIIOPAddressComponent;
import com.sun.corba.se.spi.ior.iiop.IIOPAddress;
import com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.transport.IORToSocketInfo;
import com.sun.corba.se.spi.transport.SocketInfo;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.omg.CORBA.portable.InputStream;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.CSIIOP.TransportAddress;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;

public class CSIV2IORToSocketInfo
implements IORToSocketInfo {
    private static boolean clientRequiresSsl;

    public static void setClientRequiresSSL(boolean clientRequiresSSL) {
        clientRequiresSsl = clientRequiresSSL;
    }

    public List getSocketInfo(IOR ior) {
        ArrayList<SocketInfo> result = new ArrayList<SocketInfo>();
        IIOPProfileTemplate iiopProfileTemplate = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
        IIOPAddress primary = iiopProfileTemplate.getPrimaryAddress();
        String hostname = primary.getHost().toLowerCase(Locale.ENGLISH);
        int primaryPort = primary.getPort();
        TransportAddress sslAddress = this.selectSSLTransportAddress(ior);
        SSL ssl = this.getSSL(ior);
        SocketInfo socketInfo = sslAddress != null ? this.createSSLSocketInfo(hostname, sslAddress.port) : (ssl != null ? this.createSSLSocketInfo(hostname, ssl.port) : this.createSocketInfo(hostname, primaryPort));
        result.add(socketInfo);
        this.addAlternateSocketInfos(iiopProfileTemplate, result);
        return result;
    }

    private SSL getSSL(IOR ior) {
        boolean targetSupportsSsl;
        Iterator iter = ior.getProfile().getTaggedProfileTemplate().iteratorById(20);
        if (!iter.hasNext()) {
            return null;
        }
        final ORB orb = ior.getORB();
        final org.omg.IOP.TaggedComponent compList = ((TaggedComponent)iter.next()).getIOPComponent((org.omg.CORBA.ORB)orb);
        CDRInputStream in = AccessController.doPrivileged(new PrivilegedAction<CDRInputStream>(){

            @Override
            public CDRInputStream run() {
                return new EncapsInputStream((org.omg.CORBA.ORB)orb, compList.component_data, compList.component_data.length);
            }
        });
        in.consumeEndian();
        SSL ssl = SSLHelper.read((InputStream)in);
        boolean targetRequiresSsl = ssl.target_requires > 0;
        boolean bl = targetSupportsSsl = ssl.target_supports > 0;
        if (!targetSupportsSsl && clientRequiresSsl) {
            throw IIOPLogger.ROOT_LOGGER.serverDoesNotSupportSsl();
        }
        return targetSupportsSsl && (targetRequiresSsl || clientRequiresSsl) ? ssl : null;
    }

    private TransportAddress selectSSLTransportAddress(IOR ior) {
        CompoundSecMechList compoundSecMechList = this.readCompoundSecMechList(ior);
        if (compoundSecMechList != null) {
            for (CompoundSecMech mech : compoundSecMechList.mechanism_list) {
                TLS_SEC_TRANS sslMech = this.extractTlsSecTrans(ior, mech);
                if (sslMech == null) continue;
                boolean targetSupportsSsl = this.checkSSL(sslMech.target_supports);
                boolean targetRequiresSsl = this.checkSSL(sslMech.target_requires);
                if (!targetSupportsSsl && clientRequiresSsl) {
                    throw IIOPLogger.ROOT_LOGGER.serverDoesNotSupportSsl();
                }
                if (!targetSupportsSsl || !targetRequiresSsl && !clientRequiresSsl) continue;
                return this.extractAddress(sslMech);
            }
        }
        return null;
    }

    private boolean checkSSL(int options) {
        return (options & 0x7E) != 0;
    }

    private CompoundSecMechList readCompoundSecMechList(IOR ior) {
        Iterator iter = ior.getProfile().getTaggedProfileTemplate().iteratorById(33);
        if (!iter.hasNext()) {
            return null;
        }
        final ORB orb = ior.getORB();
        final org.omg.IOP.TaggedComponent compList = ((TaggedComponent)iter.next()).getIOPComponent((org.omg.CORBA.ORB)orb);
        CDRInputStream in = AccessController.doPrivileged(new PrivilegedAction<CDRInputStream>(){

            @Override
            public CDRInputStream run() {
                return new EncapsInputStream((org.omg.CORBA.ORB)orb, compList.component_data, compList.component_data.length);
            }
        });
        in.consumeEndian();
        return CompoundSecMechListHelper.read((InputStream)in);
    }

    private TLS_SEC_TRANS extractTlsSecTrans(IOR ior, CompoundSecMech mech) {
        final org.omg.IOP.TaggedComponent comp = mech.transport_mech;
        if (comp.tag != 36) {
            return null;
        }
        final ORB orb = ior.getORB();
        CDRInputStream in = AccessController.doPrivileged(new PrivilegedAction<CDRInputStream>(){

            @Override
            public CDRInputStream run() {
                return new EncapsInputStream((org.omg.CORBA.ORB)orb, comp.component_data, comp.component_data.length);
            }
        });
        in.consumeEndian();
        return TLS_SEC_TRANSHelper.read((InputStream)in);
    }

    private TransportAddress extractAddress(TLS_SEC_TRANS sslMech) {
        if (sslMech.addresses.length == 0) {
            return null;
        }
        return sslMech.addresses[0];
    }

    private void addAlternateSocketInfos(IIOPProfileTemplate iiopProfileTemplate, List result) {
        Iterator iterator = iiopProfileTemplate.iteratorById(3);
        while (iterator.hasNext()) {
            AlternateIIOPAddressComponent alternate = (AlternateIIOPAddressComponent)iterator.next();
            String hostname = alternate.getAddress().getHost().toLowerCase();
            int port = alternate.getAddress().getPort();
            SocketInfo socketInfo = this.createSocketInfo(hostname, port);
            result.add(socketInfo);
        }
    }

    private SocketInfo createSocketInfo(final String hostname, final int port) {
        return new SocketInfo(){

            public String getType() {
                return "IIOP_CLEAR_TEXT";
            }

            public String getHost() {
                return hostname;
            }

            public int getPort() {
                return port;
            }
        };
    }

    private SocketInfo createSSLSocketInfo(final String hostname, final int port) {
        return new SocketInfo(){

            public String getType() {
                return "SSL";
            }

            public String getHost() {
                return hostname;
            }

            public int getPort() {
                return port;
            }
        };
    }
}

