/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.edit;

import org.jboss.aesh.console.Console;
import org.jboss.aesh.edit.EditMode;

public abstract class AbstractEditMode
implements EditMode {
    private Console console;
    private static final String IGNOREEOF = "IGNOREEOF";
    protected int eofCounter;
    protected int ignoreEof = 0;
    private boolean askForCompletions = false;

    @Override
    public void init(Console console) {
        this.console = console;
        this.eofCounter = 0;
    }

    @Override
    public void setAskForCompletions(boolean askForCompletions) {
        this.askForCompletions = askForCompletions;
    }

    protected boolean isAskingForCompletions() {
        return this.askForCompletions;
    }

    protected void checkEof() {
        String strValue = "1";
        if (this.console != null && this.console.getExportManager() != null) {
            strValue = this.console.getExportManager().getValueIgnoreCase(IGNOREEOF);
        }
        try {
            int eofValue = Integer.parseInt(strValue);
            this.ignoreEof = eofValue > -1 ? eofValue : 0;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void resetEOF() {
        this.eofCounter = 0;
    }
}

