/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.metadata;

import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.drools.core.metadata.Identifiable;
import org.drools.core.metadata.MetaClass;
import org.drools.core.metadata.MetaProperty;
import org.drools.core.metadata.MetadataHolder;
import org.drools.core.metadata.Metadatable;

public abstract class MetadataContainer<T extends Metadatable>
implements Serializable {
    protected transient T target;
    protected MetaClass metaClassInfo;

    public MetadataContainer(T metadatableObject) {
        this.target = metadatableObject;
    }

    public MetaClass<T> getMetaClassInfo() {
        return this.metaClassInfo;
    }

    protected T getTarget() {
        return this.target;
    }

    public void setTarget(T target) {
        this.target = target;
    }

    public List<MetaProperty<T, ?, ?>> properties() {
        return Collections.unmodifiableList(Arrays.asList(this.getMetaClassInfo().getProperties()));
    }

    public String[] propertyNames() {
        String[] names = new String[this.metaClassInfo.getProperties().length];
        for (int j = 0; j < this.metaClassInfo.getProperties().length; ++j) {
            names[j] = this.metaClassInfo.getProperties()[j].getName();
        }
        return names;
    }

    protected <T, R> MetaProperty<T, R, ?> getProperty(String name) {
        for (MetaProperty p : this.metaClassInfo.getProperties()) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    protected <T, R> MetaProperty getProperty(int index) {
        return this.metaClassInfo.getProperties()[index];
    }

    public static URI getIdentifier(Object object) {
        if (object instanceof Identifiable) {
            URI uri = ((Identifiable)object).getUri();
            return uri != null ? uri : URI.create(MetadataContainer.createObjectIdentifier(object));
        }
        if (object instanceof MetadataHolder) {
            return URI.create(MetadataContainer.createObjectIdentifier(((MetadataHolder)object).get_().getMetaClassInfo().getUri().toString(), object));
        }
        return URI.create(MetadataContainer.createObjectIdentifier(object));
    }

    protected static String createObjectIdentifier(Object target) {
        return MetadataContainer.createObjectIdentifier("urn:" + target.getClass().getPackage().getName(), target);
    }

    protected static String createObjectIdentifier(String classUri, Object target) {
        StringBuilder sb = new StringBuilder();
        sb.append(classUri).append("/").append(target.getClass().getSimpleName()).append("/").append(System.identityHashCode(target));
        return sb.toString();
    }
}

