/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.netty.transport;

import io.netty.channel.EventLoop;
import java.io.IOException;
import java.net.SocketAddress;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.XnioIoThread;
import org.xnio.channels.AcceptingChannel;
import org.xnio.netty.transport.AbstractXnioServerSocketChannel;
import org.xnio.netty.transport.IoThreadPowered;
import org.xnio.netty.transport.XnioEventLoop;

public final class WrappingXnioServerSocketChannel
extends AbstractXnioServerSocketChannel
implements IoThreadPowered {
    private final AcceptingChannel channel;
    private final XnioIoThread thread;

    public WrappingXnioServerSocketChannel(AcceptingChannel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        this.channel = channel;
        this.thread = channel.getIoThread();
        channel.getAcceptSetter().set((ChannelListener)new AbstractXnioServerSocketChannel.AcceptListener());
        this.unsafe().register((EventLoop)new XnioEventLoop(channel.getWorker().getIoThread()), this.unsafe().voidPromise());
        this.read();
    }

    @Override
    public XnioIoThread ioThread() {
        return this.thread;
    }

    @Override
    protected <T> void setOption0(Option<T> option, T value) throws IOException {
        this.channel.setOption(option, value);
    }

    @Override
    protected <T> T getOption0(Option<T> option) throws IOException {
        return (T)this.channel.getOption(option);
    }

    protected void doBind(SocketAddress localAddress) throws Exception {
        throw new UnsupportedOperationException("Wrapped XNIO Channel");
    }

    @Override
    protected AcceptingChannel xnioChannel() {
        return this.channel;
    }
}

