/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.Collection;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.naming.ContextListManagedReferenceFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.arquillian.WeldContextSetup;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.services.BeanManagerService;
import org.jboss.as.weld.util.Utils;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class WeldBeanManagerServiceProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit topLevelDeployment = Utils.getRootDeploymentUnit(deploymentUnit);
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        if (!WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)topLevelDeployment)) {
            return;
        }
        Collection dependencies = (Collection)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.JNDI_DEPENDENCIES);
        BeanDeploymentArchiveImpl rootBda = (BeanDeploymentArchiveImpl)deploymentUnit.getAttachment(WeldAttachments.DEPLOYMENT_ROOT_BEAN_DEPLOYMENT_ARCHIVE);
        if (rootBda == null) {
            rootBda = (BeanDeploymentArchiveImpl)topLevelDeployment.getAttachment(WeldAttachments.DEPLOYMENT_ROOT_BEAN_DEPLOYMENT_ARCHIVE);
        }
        if (rootBda == null) {
            WeldLogger.DEPLOYMENT_LOGGER.couldNotFindBeanManagerForDeployment(deploymentUnit.getName());
            return;
        }
        ServiceName weldServiceName = topLevelDeployment.getServiceName().append(WeldBootstrapService.SERVICE_NAME);
        ServiceName beanManagerServiceName = BeanManagerService.serviceName(deploymentUnit);
        BeanManagerService beanManagerService = new BeanManagerService(rootBda.getId());
        serviceTarget.addService(beanManagerServiceName, (Service)beanManagerService).addDependency(weldServiceName, WeldBootstrapService.class, beanManagerService.getWeldContainer()).install();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit) || deploymentUnit.getName().endsWith(".jar")) {
            ServiceName moduleContextServiceName = ContextNames.contextServiceNameOfModule((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName());
            this.bindBeanManager(serviceTarget, beanManagerServiceName, moduleContextServiceName, dependencies, phaseContext.getServiceRegistry());
        }
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (component.getNamingMode() != ComponentNamingMode.CREATE) continue;
            ServiceName compContextServiceName = ContextNames.contextServiceNameOfComponent((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName(), (String)component.getComponentName());
            this.bindBeanManager(serviceTarget, beanManagerServiceName, compContextServiceName, dependencies, phaseContext.getServiceRegistry());
        }
        deploymentUnit.addToAttachmentList(org.jboss.as.server.deployment.Attachments.SETUP_ACTIONS, (Object)new WeldContextSetup());
    }

    private void bindBeanManager(ServiceTarget serviceTarget, ServiceName beanManagerServiceName, ServiceName contextServiceName, Collection<ServiceName> dependencies, ServiceRegistry serviceRegistry) {
        ServiceName beanManagerBindingServiceName = contextServiceName.append(new String[]{"BeanManager"});
        dependencies.add(beanManagerBindingServiceName);
        BinderService beanManagerBindingService = new BinderService("BeanManager");
        BeanManagerManagedReferenceFactory referenceFactory = new BeanManagerManagedReferenceFactory();
        serviceTarget.addService(beanManagerBindingServiceName, (Service)beanManagerBindingService).addInjection((Injector)beanManagerBindingService.getManagedObjectInjector(), (Object)referenceFactory).addDependency(contextServiceName, ServiceBasedNamingStore.class, (Injector)beanManagerBindingService.getNamingStoreInjector()).addDependency(beanManagerServiceName, BeanManager.class, (Injector)referenceFactory.beanManager).install();
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.getAttachmentList(org.jboss.as.server.deployment.Attachments.SETUP_ACTIONS).removeIf(setupAction -> setupAction instanceof WeldContextSetup);
    }

    private static class BeanManagerManagedReferenceFactory
    implements ContextListManagedReferenceFactory {
        private final InjectedValue<BeanManager> beanManager = new InjectedValue();

        private BeanManagerManagedReferenceFactory() {
        }

        public ManagedReference getReference() {
            BeanManager bm = (BeanManager)this.beanManager.getOptionalValue();
            if (bm == null) {
                return null;
            }
            return new ValueManagedReference((Value)new ImmediateValue((Object)bm));
        }

        public String getInstanceClassName() {
            return BeanManager.class.getName();
        }
    }
}

