/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.challenge;

import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.authenticators.challenge.BasicAuthAuthenticator;
import org.keycloak.credential.CredentialInput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;

public class BasicAuthOTPAuthenticator
extends BasicAuthAuthenticator
implements Authenticator {
    @Override
    protected boolean onAuthenticate(AuthenticationFlowContext context, String[] challenge) {
        String otp;
        String username = challenge[0];
        String password = challenge[1];
        OTPPolicy otpPolicy = context.getRealm().getOTPPolicy();
        int otpLength = otpPolicy.getDigits();
        if (password.length() < otpLength) {
            return false;
        }
        return this.checkUsernameAndPassword(context, username, password = password.substring(0, password.length() - otpLength)) && this.checkOtp(context, otp = password.substring(password.length() - otpLength));
    }

    private boolean checkOtp(AuthenticationFlowContext context, String otp) {
        return context.getSession().userCredentialManager().isValid(context.getRealm(), context.getUser(), new CredentialInput[]{UserCredentialModel.otp((String)context.getRealm().getOTPPolicy().getType(), (String)otp)});
    }

    @Override
    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return session.userCredentialManager().isConfiguredFor(realm, user, realm.getOTPPolicy().getType());
    }
}

