/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;

public final class Permissions {
    public static ResourcePermission permission(ResourceServer server, Resource resource, Scope scope) {
        return new ResourcePermission(resource, new ArrayList<Scope>(Arrays.asList(scope)), server);
    }

    public static List<ResourcePermission> all(ResourceServer resourceServer, Identity identity, AuthorizationProvider authorization, AuthorizationRequest request) {
        ArrayList<ResourcePermission> permissions = new ArrayList<ResourcePermission>();
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        AuthorizationRequest.Metadata metadata = request.getMetadata();
        AtomicLong limit = metadata != null && metadata.getLimit() != null ? new AtomicLong(metadata.getLimit().intValue()) : new AtomicLong(Long.MAX_VALUE);
        resourceStore.findByOwner(resourceServer.getId(), resourceServer.getId(), resource -> {
            if (limit.decrementAndGet() >= 0L) {
                permissions.add(Permissions.createResourcePermissions(resource, authorization, request));
            }
        });
        resourceStore.findByOwner(identity.getId(), resourceServer.getId(), resource -> {
            if (limit.decrementAndGet() >= 0L) {
                permissions.add(Permissions.createResourcePermissions(resource, authorization, request));
            }
        });
        List tickets = storeFactory.getPermissionTicketStore().findGranted(identity.getId(), resourceServer.getId());
        if (!tickets.isEmpty()) {
            HashMap<String, ResourcePermission> userManagedPermissions = new HashMap<String, ResourcePermission>();
            for (PermissionTicket ticket : tickets) {
                ResourcePermission permission = (ResourcePermission)userManagedPermissions.get(ticket.getResource().getId());
                if (permission == null) {
                    userManagedPermissions.put(ticket.getResource().getId(), new ResourcePermission(ticket.getResource(), new ArrayList(), resourceServer, request.getClaims()));
                    limit.decrementAndGet();
                }
                if (limit.decrementAndGet() > 0L) continue;
                break;
            }
            permissions.addAll(userManagedPermissions.values());
        }
        return permissions;
    }

    public static ResourcePermission createResourcePermissions(Resource resource, Collection<Scope> requestedScopes, AuthorizationProvider authorization, AuthorizationRequest request) {
        List<Object> scopes = requestedScopes.isEmpty() ? Permissions.populateTypedScopes(resource, authorization) : requestedScopes.stream().filter(scope -> resource.getScopes().contains(scope)).collect(Collectors.toList());
        return new ResourcePermission(resource, scopes, resource.getResourceServer(), request.getClaims());
    }

    public static ResourcePermission createResourcePermissions(Resource resource, AuthorizationProvider authorization, AuthorizationRequest request) {
        List requestedScopes = resource.getScopes();
        if (requestedScopes.isEmpty()) {
            return new ResourcePermission(resource, Permissions.populateTypedScopes(resource, authorization), resource.getResourceServer(), request.getClaims());
        }
        return new ResourcePermission(resource, resource.getResourceServer(), request.getClaims());
    }

    private static List<Scope> populateTypedScopes(Resource resource, AuthorizationProvider authorization) {
        LinkedList<Scope> scopes = new LinkedList<Scope>(resource.getScopes());
        String type = resource.getType();
        ResourceServer resourceServer = resource.getResourceServer();
        if (type != null && !resource.getOwner().equals(resourceServer.getId())) {
            StoreFactory storeFactory = authorization.getStoreFactory();
            ResourceStore resourceStore = storeFactory.getResourceStore();
            resourceStore.findByType(type, resourceServer.getId(), resource1 -> {
                if (resource1.getOwner().equals(resourceServer.getId())) {
                    for (Scope typeScope : resource1.getScopes()) {
                        if (scopes.contains(typeScope)) continue;
                        scopes.add(typeScope);
                    }
                }
            });
        }
        return scopes;
    }
}

