/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.util.TokenUtil;

public class DefaultClientSessionContext
implements ClientSessionContext {
    private static Logger logger = Logger.getLogger(DefaultClientSessionContext.class);
    private final AuthenticatedClientSessionModel clientSession;
    private final Set<String> clientScopeIds;
    private Set<ClientScopeModel> clientScopes;
    private Set<RoleModel> roles;
    private Set<ProtocolMapperModel> protocolMappers;

    private DefaultClientSessionContext(AuthenticatedClientSessionModel clientSession, Set<String> clientScopeIds) {
        this.clientSession = clientSession;
        this.clientScopeIds = clientScopeIds;
    }

    public static DefaultClientSessionContext fromClientSessionScopeParameter(AuthenticatedClientSessionModel clientSession) {
        return DefaultClientSessionContext.fromClientSessionAndScopeParameter(clientSession, clientSession.getNote("scope"));
    }

    public static DefaultClientSessionContext fromClientSessionAndScopeParameter(AuthenticatedClientSessionModel clientSession, String scopeParam) {
        Set<ClientScopeModel> requestedClientScopes = TokenManager.getRequestedClientScopes(scopeParam, clientSession.getClient());
        return DefaultClientSessionContext.fromClientSessionAndClientScopes(clientSession, requestedClientScopes);
    }

    public static DefaultClientSessionContext fromClientSessionAndClientScopeIds(AuthenticatedClientSessionModel clientSession, Set<String> clientScopeIds) {
        return new DefaultClientSessionContext(clientSession, clientScopeIds);
    }

    public static DefaultClientSessionContext fromClientSessionAndClientScopes(AuthenticatedClientSessionModel clientSession, Set<ClientScopeModel> clientScopes) {
        HashSet<String> clientScopeIds = new HashSet<String>();
        for (ClientScopeModel clientScope : clientScopes) {
            clientScopeIds.add(clientScope.getId());
        }
        DefaultClientSessionContext ctx = new DefaultClientSessionContext(clientSession, clientScopeIds);
        ctx.clientScopes = new HashSet<ClientScopeModel>(clientScopes);
        return ctx;
    }

    public AuthenticatedClientSessionModel getClientSession() {
        return this.clientSession;
    }

    public Set<String> getClientScopeIds() {
        return this.clientScopeIds;
    }

    public Set<ClientScopeModel> getClientScopes() {
        if (this.clientScopes == null) {
            this.clientScopes = this.loadClientScopes();
        }
        return this.clientScopes;
    }

    public Set<RoleModel> getRoles() {
        if (this.roles == null) {
            this.roles = this.loadRoles();
        }
        return this.roles;
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        if (this.protocolMappers == null) {
            this.protocolMappers = this.loadProtocolMappers();
        }
        return this.protocolMappers;
    }

    public String getScopeString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (ClientScopeModel clientScope : this.getClientScopes()) {
            if (clientScope instanceof ClientModel) continue;
            if (first) {
                first = false;
            } else {
                builder.append(" ");
            }
            builder.append(clientScope.getName());
        }
        String scopeParam = builder.toString();
        String scopeSent = this.clientSession.getNote("scope");
        if (TokenUtil.isOIDCRequest((String)scopeSent)) {
            scopeParam = TokenUtil.attachOIDCScope((String)scopeParam);
        }
        return scopeParam;
    }

    private Set<ClientScopeModel> loadClientScopes() {
        HashSet<ClientScopeModel> clientScopes = new HashSet<ClientScopeModel>();
        for (String scopeId : this.clientScopeIds) {
            ClientScopeModel clientScope = KeycloakModelUtils.findClientScopeById((RealmModel)this.clientSession.getClient().getRealm(), (String)scopeId);
            if (clientScope == null) continue;
            clientScopes.add(clientScope);
        }
        return clientScopes;
    }

    private Set<RoleModel> loadRoles() {
        UserModel user = this.clientSession.getUserSession().getUser();
        ClientModel client = this.clientSession.getClient();
        Set<ClientScopeModel> clientScopes = this.getClientScopes();
        return TokenManager.getAccess(user, client, clientScopes);
    }

    private Set<ProtocolMapperModel> loadProtocolMappers() {
        Set<ClientScopeModel> clientScopes = this.getClientScopes();
        String protocol = this.clientSession.getClient().getProtocol();
        if (protocol == null) {
            logger.warnf("Client '%s' doesn't have protocol set. Fallback to openid-connect. Please fix client configuration", (Object)this.clientSession.getClient().getClientId());
            protocol = "openid-connect";
        }
        HashSet<ProtocolMapperModel> protocolMappers = new HashSet<ProtocolMapperModel>();
        for (ClientScopeModel clientScope : clientScopes) {
            Set currentMappers = clientScope.getProtocolMappers();
            for (ProtocolMapperModel currentMapper : currentMappers) {
                if (!protocol.equals(currentMapper.getProtocol())) continue;
                protocolMappers.add(currentMapper);
            }
        }
        return protocolMappers;
    }
}

