/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.util.EnumSet;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.ModuleBuilder;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanBindingFactory;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerBuilder;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResourceDefinition;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.RemoteCacheContainer;

public class RemoteCacheContainerServiceHandler
extends SimpleResourceServiceHandler<Configuration> {
    RemoteCacheContainerServiceHandler(ResourceServiceBuilderFactory<Configuration> builderFactory) {
        super(builderFactory);
    }

    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        super.installServices(context, model);
        PathAddress address = context.getCurrentAddress();
        String name = context.getCurrentAddressValue();
        ServiceTarget target = context.getServiceTarget();
        new ModuleBuilder(RemoteCacheContainerComponent.MODULE.getServiceName(address), (Attribute)RemoteCacheContainerResourceDefinition.Attribute.MODULE).configure(context, model).build(target).setInitialMode(ServiceController.Mode.PASSIVE).install();
        RemoteCacheContainerBuilder containerBuilder = new RemoteCacheContainerBuilder(address).configure(context, model);
        containerBuilder.build(target).install();
        new BinderServiceBuilder(InfinispanBindingFactory.createRemoteCacheContainerBinding(name), containerBuilder.getServiceName(), RemoteCacheContainer.class).build(target).install();
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String name = context.getCurrentAddressValue();
        context.removeService(InfinispanBindingFactory.createRemoteCacheContainerBinding(name).getBinderServiceName());
        for (RemoteCacheContainerResourceDefinition.Capability component : EnumSet.allOf(RemoteCacheContainerResourceDefinition.Capability.class)) {
            ServiceName serviceName = component.getServiceName(address);
            context.removeService(serviceName);
        }
        context.removeService(RemoteCacheContainerComponent.MODULE.getServiceName(address));
        super.removeServices(context, model);
    }
}

