/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.field;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.spi.FieldValue;
import org.drools.core.util.MathUtils;

public class ObjectFieldImpl
implements FieldValue,
Externalizable {
    private static final long serialVersionUID = 510L;
    private Object value;
    private boolean isEnum;
    private String enumName;
    private String fieldName;
    private transient boolean isCollection;
    private transient boolean isNumber;
    private transient boolean isBoolean;
    private transient boolean isCharacter;
    private transient boolean isString;

    public ObjectFieldImpl() {
        this(null);
    }

    public ObjectFieldImpl(Object value) {
        this.value = value;
        this.isEnum = value instanceof Enum;
        this.setBooleans();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.isEnum = in.readBoolean();
        this.enumName = (String)in.readObject();
        this.fieldName = (String)in.readObject();
        if (!this.isEnum || this.enumName == null || this.fieldName == null) {
            this.value = (Serializable)in.readObject();
        } else {
            this.resolveEnumValue((DroolsObjectInputStream)in);
        }
        this.setBooleans();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.isEnum);
        out.writeObject(this.enumName);
        out.writeObject(this.fieldName);
        if (!this.isEnum || this.enumName == null || this.fieldName == null) {
            out.writeObject(this.value);
        }
    }

    private void resolveEnumValue(DroolsObjectInputStream in) {
        try {
            ClassLoader loader = in.getClassLoader();
            Class<?> staticClass = Class.forName(this.enumName, true, loader);
            this.value = (Serializable)staticClass.getField(this.fieldName).get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Error deserializing enum value " + this.enumName + "." + this.fieldName + " : " + e.getMessage());
        }
    }

    private void setBooleans() {
        this.isCollection = this.value instanceof Collection;
        this.isNumber = this.value instanceof Number;
        this.isBoolean = this.value instanceof Boolean;
        this.isCharacter = this.value instanceof Character;
        this.isString = this.value instanceof String;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.value == null ? "null" : this.value.toString();
    }

    @Override
    public boolean getBooleanValue() {
        if (this.isBoolean) {
            return (Boolean)this.value;
        }
        if (this.isString) {
            return Boolean.valueOf((String)this.value);
        }
        throw new RuntimeException("Conversion to boolean not supported for type: " + this.value.getClass());
    }

    @Override
    public byte getByteValue() {
        if (this.isNumber) {
            return ((Number)this.value).byteValue();
        }
        if (this.isString) {
            return Byte.valueOf((String)this.value);
        }
        throw new RuntimeException("Conversion to byte not supported for type: " + this.value.getClass());
    }

    @Override
    public char getCharValue() {
        if (this.isCharacter) {
            return ((Character)this.value).charValue();
        }
        if (this.isString && ((String)this.value).length() == 1) {
            return ((String)this.value).charAt(0);
        }
        throw new RuntimeException("Conversion to char not supported for type: " + this.value.getClass());
    }

    @Override
    public double getDoubleValue() {
        if (this.isNumber) {
            return ((Number)this.value).doubleValue();
        }
        if (this.isString) {
            return Double.valueOf((String)this.value);
        }
        throw new RuntimeException("Conversion to double not supported for type: " + this.value.getClass());
    }

    @Override
    public float getFloatValue() {
        if (this.isNumber) {
            return ((Number)this.value).floatValue();
        }
        if (this.isString) {
            return Float.valueOf((String)this.value).floatValue();
        }
        throw new RuntimeException("Conversion to float not supported for type: " + this.value.getClass());
    }

    @Override
    public int getIntValue() {
        if (this.isNumber) {
            return ((Number)this.value).intValue();
        }
        if (this.isString) {
            return Integer.valueOf((String)this.value);
        }
        throw new RuntimeException("Conversion to int not supported for type: " + this.value.getClass());
    }

    @Override
    public long getLongValue() {
        if (this.isNumber) {
            return ((Number)this.value).longValue();
        }
        if (this.isString) {
            return Long.valueOf((String)this.value);
        }
        throw new RuntimeException("Conversion to long not supported for type: " + this.value.getClass());
    }

    @Override
    public short getShortValue() {
        if (this.isNumber) {
            return ((Number)this.value).shortValue();
        }
        if (this.isString) {
            return Short.valueOf((String)this.value);
        }
        throw new RuntimeException("Conversion to short not supported for type: " + this.value.getClass());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ObjectFieldImpl)) {
            return false;
        }
        ObjectFieldImpl other = (ObjectFieldImpl)object;
        return this.value == null && other.value == null || this.value != null && this.value.equals(other.value);
    }

    public int hashCode() {
        if (this.value != null) {
            return this.value.hashCode();
        }
        return 0;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean isBooleanField() {
        return false;
    }

    @Override
    public boolean isFloatNumberField() {
        return false;
    }

    @Override
    public boolean isIntegerNumberField() {
        return false;
    }

    @Override
    public boolean isObjectField() {
        return true;
    }

    @Override
    public boolean isCollectionField() {
        return this.isCollection;
    }

    @Override
    public boolean isStringField() {
        return this.isString;
    }

    @Override
    public BigDecimal getBigDecimalValue() {
        return MathUtils.getBigDecimal(this.value);
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return MathUtils.getBigInteger(this.value);
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public void setEnum(boolean isEnum) {
        this.isEnum = isEnum;
    }

    public String getEnumName() {
        return this.enumName;
    }

    public void setEnumName(String enumName) {
        this.enumName = enumName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }
}

