/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.entities;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.Scope;
import org.keycloak.models.cache.infinispan.authorization.entities.InResourceServer;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;

public class CachedPolicy
extends AbstractRevisioned
implements InResourceServer {
    private String type;
    private DecisionStrategy decisionStrategy;
    private Logic logic;
    private Map<String, String> config;
    private String name;
    private String description;
    private String resourceServerId;
    private Set<String> associatedPoliciesIds;
    private Set<String> resourcesIds;
    private Set<String> scopesIds;
    private final String owner;

    public CachedPolicy(Long revision, Policy policy) {
        super(revision, policy.getId());
        this.type = policy.getType();
        this.decisionStrategy = policy.getDecisionStrategy();
        this.logic = policy.getLogic();
        this.config = new HashMap<String, String>(policy.getConfig());
        this.name = policy.getName();
        this.description = policy.getDescription();
        this.resourceServerId = policy.getResourceServer().getId();
        this.associatedPoliciesIds = policy.getAssociatedPolicies().stream().map(Policy::getId).collect(Collectors.toSet());
        this.resourcesIds = policy.getResources().stream().map(Resource::getId).collect(Collectors.toSet());
        this.scopesIds = policy.getScopes().stream().map(Scope::getId).collect(Collectors.toSet());
        this.owner = policy.getOwner();
    }

    public String getType() {
        return this.type;
    }

    public DecisionStrategy getDecisionStrategy() {
        return this.decisionStrategy;
    }

    public Logic getLogic() {
        return this.logic;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<String> getAssociatedPoliciesIds() {
        return this.associatedPoliciesIds;
    }

    public Set<String> getResourcesIds() {
        return this.resourcesIds;
    }

    public Set<String> getScopesIds() {
        return this.scopesIds;
    }

    @Override
    public String getResourceServerId() {
        return this.resourceServerId;
    }

    public String getOwner() {
        return this.owner;
    }
}

