/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.io.Serializable;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.context.Flag;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.util.Retry;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.initializer.BaseCacheInitializer;
import org.keycloak.models.sessions.infinispan.initializer.OfflinePersistentUserSessionLoaderContext;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;

public class OfflinePersistentUserSessionLoader
implements SessionLoader<OfflinePersistentUserSessionLoaderContext>,
Serializable {
    private static final Logger log = Logger.getLogger(OfflinePersistentUserSessionLoader.class);
    public static final String PERSISTENT_SESSIONS_LOADED = "PERSISTENT_SESSIONS_LOADED";
    public static final String PERSISTENT_SESSIONS_LOADED_IN_CURRENT_DC = "PERSISTENT_SESSIONS_LOADED_IN_CURRENT_DC";
    private final int sessionsPerSegment;

    public OfflinePersistentUserSessionLoader(int sessionsPerSegment) {
        this.sessionsPerSegment = sessionsPerSegment;
    }

    @Override
    public void init(KeycloakSession session) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class);
        int clusterStartupTime = ((ClusterProvider)session.getProvider(ClusterProvider.class)).getClusterStartupTime();
        log.debugf("Clearing detached sessions from persistent storage and updating timestamps to %d", clusterStartupTime);
        persister.clearDetachedUserSessions();
        persister.updateAllTimestamps(clusterStartupTime);
    }

    @Override
    public OfflinePersistentUserSessionLoaderContext computeLoaderContext(KeycloakSession session) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class);
        int sessionsCount = persister.getUserSessionsCount(true);
        return new OfflinePersistentUserSessionLoaderContext(sessionsCount, this.sessionsPerSegment);
    }

    @Override
    public boolean loadSessions(KeycloakSession session, OfflinePersistentUserSessionLoaderContext ctx, int segment) {
        int first = ctx.getSessionsPerSegment() * segment;
        int max = this.sessionsPerSegment;
        if (log.isTraceEnabled()) {
            log.tracef("Loading sessions - first: %d, max: %d", first, max);
        }
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class);
        List sessions = persister.loadUserSessions(first, max, true);
        for (UserSessionModel persistentSession : sessions) {
            UserSessionModel userSessionModel = session.sessions().importUserSession(persistentSession, true, true);
        }
        return true;
    }

    @Override
    public boolean isFinished(BaseCacheInitializer initializer) {
        Cache<String, Serializable> workCache = initializer.getWorkCache();
        Boolean sessionsLoaded = (Boolean)workCache.get((Object)PERSISTENT_SESSIONS_LOADED);
        if (sessionsLoaded != null && sessionsLoaded.booleanValue()) {
            log.debugf("Persistent sessions loaded already.", new Object[0]);
            return true;
        }
        log.debugf("Persistent sessions not yet loaded.", new Object[0]);
        return false;
    }

    @Override
    public void afterAllSessionsLoaded(BaseCacheInitializer initializer) {
        Cache<String, Serializable> workCache = initializer.getWorkCache();
        Retry.executeWithBackoff(iteration -> {
            try {
                workCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).put((Object)PERSISTENT_SESSIONS_LOADED, (Object)true);
            }
            catch (HotRodClientException re) {
                log.warnf((Throwable)re, "Failed to write flag PERSISTENT_SESSIONS_LOADED in iteration '%d' . Retrying", (Object)iteration);
                throw re;
            }
        }, (int)10, (int)10);
        workCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_CACHE_LOAD, Flag.SKIP_CACHE_STORE}).put((Object)PERSISTENT_SESSIONS_LOADED_IN_CURRENT_DC, (Object)true);
        log.debugf("Persistent sessions loaded successfully!", new Object[0]);
    }

    public String toString() {
        return "OfflinePersistentUserSessionLoader [ " + "sessionsPerSegment: " + this.sessionsPerSegment + " ]";
    }
}

