/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.service.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.hibernate.event.service.internal.EventListenerRegistryImpl;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistrationException;
import org.hibernate.event.service.spi.JpaBootstrapSensitive;
import org.hibernate.event.spi.EventType;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;

class EventListenerGroupImpl<T>
implements EventListenerGroup<T> {
    private EventType<T> eventType;
    private final EventListenerRegistryImpl listenerRegistry;
    private final Set<DuplicationStrategy> duplicationStrategies = new LinkedHashSet<DuplicationStrategy>();
    private List<T> listeners;

    public EventListenerGroupImpl(EventType<T> eventType, EventListenerRegistryImpl listenerRegistry) {
        this.eventType = eventType;
        this.listenerRegistry = listenerRegistry;
        this.duplicationStrategies.add(new DuplicationStrategy(){

            @Override
            public boolean areMatch(Object listener, Object original) {
                return listener.getClass().equals(original.getClass());
            }

            @Override
            public DuplicationStrategy.Action getAction() {
                return DuplicationStrategy.Action.ERROR;
            }
        });
    }

    @Override
    public EventType<T> getEventType() {
        return this.eventType;
    }

    @Override
    public boolean isEmpty() {
        return this.count() <= 0;
    }

    @Override
    public int count() {
        return this.listeners == null ? 0 : this.listeners.size();
    }

    @Override
    public void clear() {
        if (this.duplicationStrategies != null) {
            this.duplicationStrategies.clear();
        }
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    @Override
    public void addDuplicationStrategy(DuplicationStrategy strategy) {
        this.duplicationStrategies.add(strategy);
    }

    @Override
    public Iterable<T> listeners() {
        return this.listeners == null ? Collections.emptyList() : this.listeners;
    }

    @Override
    @SafeVarargs
    public final void appendListeners(T ... listeners) {
        for (T listener : listeners) {
            this.appendListener(listener);
        }
    }

    @Override
    public void appendListener(T listener) {
        if (this.listenerShouldGetAdded(listener)) {
            this.internalAppend(listener);
        }
    }

    @Override
    @SafeVarargs
    public final void prependListeners(T ... listeners) {
        for (T listener : listeners) {
            this.prependListener(listener);
        }
    }

    @Override
    public void prependListener(T listener) {
        if (this.listenerShouldGetAdded(listener)) {
            this.internalPrepend(listener);
        }
    }

    private boolean listenerShouldGetAdded(T listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<T>();
            return true;
        }
        boolean doAdd = true;
        block5: for (DuplicationStrategy strategy : this.duplicationStrategies) {
            ListIterator<T> itr = this.listeners.listIterator();
            while (itr.hasNext()) {
                T existingListener = itr.next();
                if (!strategy.areMatch(listener, existingListener)) continue;
                switch (strategy.getAction()) {
                    case ERROR: {
                        throw new EventListenerRegistrationException("Duplicate event listener found");
                    }
                    case KEEP_ORIGINAL: {
                        doAdd = false;
                        break block5;
                    }
                    case REPLACE_ORIGINAL: {
                        itr.set(listener);
                        doAdd = false;
                        break block5;
                    }
                }
            }
        }
        return doAdd;
    }

    private void internalPrepend(T listener) {
        this.checkAgainstBaseInterface(listener);
        this.performInjections(listener);
        this.listeners.add(0, listener);
    }

    private void performInjections(T listener) {
        if (CallbackRegistryConsumer.class.isInstance(listener)) {
            ((CallbackRegistryConsumer)listener).injectCallbackRegistry(this.listenerRegistry.getCallbackRegistry());
        }
        if (JpaBootstrapSensitive.class.isInstance(listener)) {
            ((JpaBootstrapSensitive)listener).wasJpaBootstrap(this.listenerRegistry.getSessionFactory().getSessionFactoryOptions().isJpaBootstrap());
        }
    }

    private void checkAgainstBaseInterface(T listener) {
        if (!this.eventType.baseListenerInterface().isInstance(listener)) {
            throw new EventListenerRegistrationException("Listener did not implement expected interface [" + this.eventType.baseListenerInterface().getName() + "]");
        }
    }

    private void internalAppend(T listener) {
        this.checkAgainstBaseInterface(listener);
        this.performInjections(listener);
        this.listeners.add(listener);
    }
}

