/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.jpa.entities.PolicyEntity;
import org.keycloak.authorization.jpa.store.PolicyAdapter;
import org.keycloak.authorization.jpa.store.ResourceServerAdapter;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;

public class JPAPolicyStore
implements PolicyStore {
    private final EntityManager entityManager;
    private final AuthorizationProvider provider;

    public JPAPolicyStore(EntityManager entityManager, AuthorizationProvider provider) {
        this.entityManager = entityManager;
        this.provider = provider;
    }

    public Policy create(AbstractPolicyRepresentation representation, ResourceServer resourceServer) {
        PolicyEntity entity = new PolicyEntity();
        if (representation.getId() == null) {
            entity.setId(KeycloakModelUtils.generateId());
        } else {
            entity.setId(representation.getId());
        }
        entity.setType(representation.getType());
        entity.setName(representation.getName());
        entity.setResourceServer(ResourceServerAdapter.toEntity(this.entityManager, resourceServer));
        this.entityManager.persist((Object)entity);
        this.entityManager.flush();
        PolicyAdapter model = new PolicyAdapter(entity, this.entityManager, this.provider.getStoreFactory());
        return model;
    }

    public void delete(String id) {
        PolicyEntity policy = (PolicyEntity)this.entityManager.find(PolicyEntity.class, (Object)id);
        if (policy != null) {
            this.entityManager.remove((Object)policy);
        }
    }

    public Policy findById(String id, String resourceServerId) {
        if (id == null) {
            return null;
        }
        PolicyEntity entity = (PolicyEntity)this.entityManager.find(PolicyEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return new PolicyAdapter(entity, this.entityManager, this.provider.getStoreFactory());
    }

    public Policy findByName(String name, String resourceServerId) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByName", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("serverId", (Object)resourceServerId);
        query.setParameter("name", (Object)name);
        try {
            String id = (String)query.getSingleResult();
            return this.provider.getStoreFactory().getPolicyStore().findById(id, resourceServerId);
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public List<Policy> findByResourceServer(String resourceServerId) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByServerId", String.class);
        query.setParameter("serverId", (Object)resourceServerId);
        List result = query.getResultList();
        LinkedList<Policy> list = new LinkedList<Policy>();
        for (String id : result) {
            Policy policy = this.provider.getStoreFactory().getPolicyStore().findById(id, resourceServerId);
            if (!Objects.nonNull(policy)) continue;
            list.add(policy);
        }
        return list;
    }

    public List<Policy> findByResourceServer(Map<String, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery querybuilder = builder.createQuery(PolicyEntity.class);
        Root root = querybuilder.from(PolicyEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        querybuilder.select((Selection)root.get("id"));
        if (resourceServerId != null) {
            predicates.add(builder.equal((Expression)root.get("resourceServer").get("id"), (Object)resourceServerId));
        }
        attributes.forEach((name, value) -> {
            if ("permission".equals(name)) {
                if (Boolean.valueOf(value[0]).booleanValue()) {
                    predicates.add(root.get("type").in(new Object[]{"resource", "scope", "uma"}));
                } else {
                    predicates.add(builder.not((Expression)root.get("type").in(new Object[]{"resource", "scope", "uma"})));
                }
            } else if ("id".equals(name)) {
                predicates.add(root.get(name).in((Object[])value));
            } else if ("owner".equals(name)) {
                predicates.add(root.get(name).in((Object[])value));
            } else if ("owner_is_not_null".equals(name)) {
                predicates.add(builder.isNotNull((Expression)root.get("owner")));
            } else if ("resource".equals(name)) {
                predicates.add(root.join("resources").get("id").in((Object[])value));
            } else if ("scope".equals(name)) {
                predicates.add(root.join("scopes").get("id").in((Object[])value));
            } else if (name.startsWith("config:")) {
                predicates.add(root.joinMap("config").key().in(new Object[]{name.substring("config:".length())}));
                predicates.add(builder.like(root.joinMap("config").value().as(String.class), "%" + value[0] + "%"));
            } else {
                predicates.add(builder.like(builder.lower((Expression)root.get(name)), "%" + value[0].toLowerCase() + "%"));
            }
        });
        if (!attributes.containsKey("owner") && !attributes.containsKey("owner_is_not_null")) {
            predicates.add(builder.isNull((Expression)root.get("owner")));
        }
        querybuilder.where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        TypedQuery query = this.entityManager.createQuery(querybuilder);
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResult != -1) {
            query.setMaxResults(maxResult);
        }
        List result = query.getResultList();
        LinkedList<Policy> list = new LinkedList<Policy>();
        for (String id : result) {
            Policy policy = this.provider.getStoreFactory().getPolicyStore().findById(id, resourceServerId);
            if (!Objects.nonNull(policy)) continue;
            list.add(policy);
        }
        return list;
    }

    public List<Policy> findByResource(String resourceId, String resourceServerId) {
        LinkedList<Policy> result = new LinkedList<Policy>();
        this.findByResource(resourceId, resourceServerId, result::add);
        return result;
    }

    public void findByResource(String resourceId, String resourceServerId, Consumer<Policy> consumer) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByResource", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("resourceId", (Object)resourceId);
        query.setParameter("serverId", (Object)resourceServerId);
        PolicyStore policyStore = this.provider.getStoreFactory().getPolicyStore();
        query.getResultList().stream().map(id -> policyStore.findById(id, resourceServerId)).filter(Objects::nonNull).forEach(consumer::accept);
    }

    public List<Policy> findByResourceType(String resourceType, String resourceServerId) {
        LinkedList<Policy> result = new LinkedList<Policy>();
        this.findByResourceType(resourceType, resourceServerId, result::add);
        return result;
    }

    public void findByResourceType(String resourceType, String resourceServerId, Consumer<Policy> consumer) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByResourceType", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("type", (Object)resourceType);
        query.setParameter("serverId", (Object)resourceServerId);
        PolicyStore policyStore = this.provider.getStoreFactory().getPolicyStore();
        query.getResultList().stream().map(id -> policyStore.findById(id, resourceServerId)).filter(Objects::nonNull).forEach(consumer::accept);
    }

    public List<Policy> findByScopeIds(List<String> scopeIds, String resourceServerId) {
        if (scopeIds == null || scopeIds.isEmpty()) {
            return Collections.emptyList();
        }
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByScope", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("scopeIds", scopeIds);
        query.setParameter("serverId", (Object)resourceServerId);
        List result = query.getResultList();
        LinkedList<Policy> list = new LinkedList<Policy>();
        for (String id : result) {
            Policy policy = this.provider.getStoreFactory().getPolicyStore().findById(id, resourceServerId);
            if (!Objects.nonNull(policy)) continue;
            list.add(policy);
        }
        return list;
    }

    public List<Policy> findByScopeIds(List<String> scopeIds, String resourceId, String resourceServerId) {
        LinkedList<Policy> result = new LinkedList<Policy>();
        this.findByScopeIds(scopeIds, resourceId, resourceServerId, result::add);
        return result;
    }

    public void findByScopeIds(List<String> scopeIds, String resourceId, String resourceServerId, Consumer<Policy> consumer) {
        TypedQuery query;
        if (resourceId == null) {
            query = this.entityManager.createNamedQuery("findPolicyIdByNullResourceScope", String.class);
        } else {
            query = this.entityManager.createNamedQuery("findPolicyIdByResourceScope", String.class);
            query.setParameter("resourceId", (Object)resourceId);
        }
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("scopeIds", scopeIds);
        query.setParameter("serverId", (Object)resourceServerId);
        PolicyStore policyStore = this.provider.getStoreFactory().getPolicyStore();
        query.getResultList().stream().map(id -> policyStore.findById(id, resourceServerId)).filter(Objects::nonNull).forEach(consumer::accept);
    }

    public List<Policy> findByType(String type, String resourceServerId) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByType", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("serverId", (Object)resourceServerId);
        query.setParameter("type", (Object)type);
        List result = query.getResultList();
        LinkedList<Policy> list = new LinkedList<Policy>();
        for (String id : result) {
            Policy policy = this.provider.getStoreFactory().getPolicyStore().findById(id, resourceServerId);
            if (!Objects.nonNull(policy)) continue;
            list.add(policy);
        }
        return list;
    }

    public List<Policy> findDependentPolicies(String policyId, String resourceServerId) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByDependentPolices", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("serverId", (Object)resourceServerId);
        query.setParameter("policyId", (Object)policyId);
        List result = query.getResultList();
        LinkedList<Policy> list = new LinkedList<Policy>();
        for (String id : result) {
            Policy policy = this.provider.getStoreFactory().getPolicyStore().findById(id, resourceServerId);
            if (!Objects.nonNull(policy)) continue;
            list.add(policy);
        }
        return list;
    }
}

