/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.jgroups.ForkChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolServiceNameProvider;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.JChannel;
import org.jgroups.protocols.FORK;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.SuppliedValueService;
import org.wildfly.clustering.service.ValueDependency;

public class ForkChannelFactoryBuilder
extends CapabilityServiceNameProvider
implements ResourceServiceBuilder<ChannelFactory>,
Supplier<ChannelFactory>,
Consumer<ChannelFactory> {
    private final PathAddress address;
    private volatile List<ValueDependency<ProtocolConfiguration<? extends Protocol>>> protocols;
    private volatile ValueDependency<JChannel> parentChannel;
    private volatile ValueDependency<ChannelFactory> parentFactory;

    public ForkChannelFactoryBuilder(Capability capability, PathAddress address) {
        super(capability, address);
        this.address = address;
    }

    @Override
    public ChannelFactory get() {
        ArrayList<ProtocolConfiguration<? extends Protocol>> protocols = new ArrayList<ProtocolConfiguration<? extends Protocol>>(this.protocols.size());
        for (ValueDependency<ProtocolConfiguration<? extends Protocol>> protocolDependency : this.protocols) {
            protocols.add((ProtocolConfiguration<? extends Protocol>)protocolDependency.getValue());
        }
        return new ForkChannelFactory((JChannel)this.parentChannel.getValue(), (ChannelFactory)this.parentFactory.getValue(), protocols);
    }

    @Override
    public void accept(ChannelFactory factory) {
        ProtocolStack stack = ((JChannel)this.parentChannel.getValue()).getProtocolStack();
        FORK fork = (FORK)stack.findProtocol(FORK.class);
        fork.remove(this.address.getLastElement().getValue());
    }

    public ServiceBuilder<ChannelFactory> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new SuppliedValueService(Function.identity(), (Supplier)this, (Consumer)this)).setInitialMode(ServiceController.Mode.PASSIVE);
        for (Dependency dependency : this.protocols) {
            dependency.register(builder);
        }
        return new CompositeDependency(new Dependency[]{this.parentChannel, this.parentFactory}).register(builder);
    }

    public Builder<ChannelFactory> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        PlaceholderResource resource = context.getCurrentAddress().equals(this.address) ? context.readResourceFromRoot(this.address, false) : PlaceholderResource.INSTANCE;
        Set entries = resource.getChildren(ProtocolResourceDefinition.WILDCARD_PATH.getKey());
        this.protocols = new ArrayList<ValueDependency<ProtocolConfiguration<? extends Protocol>>>(entries.size());
        for (Resource.ResourceEntry entry : entries) {
            this.protocols.add((ValueDependency<ProtocolConfiguration<? extends Protocol>>)new InjectedValueDependency((ServiceNameProvider)new ProtocolServiceNameProvider(this.address, entry.getPathElement()), ProtocolConfiguration.class));
        }
        String channelName = this.address.getParent().getLastElement().getValue();
        this.parentChannel = new InjectedValueDependency(JGroupsRequirement.CHANNEL.getServiceName(context, channelName), JChannel.class);
        this.parentFactory = new InjectedValueDependency(JGroupsRequirement.CHANNEL_SOURCE.getServiceName(context, channelName), ChannelFactory.class);
        return this;
    }
}

