/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.jgroups.JChannelFactory;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolServiceNameProvider;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SingletonProtocolServiceNameProvider;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.RelayConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ValueDependency;

public class JChannelFactoryBuilder
extends CapabilityServiceNameProvider
implements ResourceServiceBuilder<ChannelFactory>,
ProtocolStackConfiguration,
Value<ChannelFactory> {
    private final InjectedValue<ServerEnvironment> environment = new InjectedValue();
    private final PathAddress address;
    private volatile boolean statisticsEnabled;
    private volatile ValueDependency<TransportConfiguration<? extends TP>> transport = null;
    private volatile List<ValueDependency<ProtocolConfiguration<? extends Protocol>>> protocols = null;
    private volatile ValueDependency<RelayConfiguration> relay = null;

    public JChannelFactoryBuilder(PathAddress address) {
        super((Capability)StackResourceDefinition.Capability.JCHANNEL_FACTORY, address);
        this.address = address;
    }

    public ChannelFactory getValue() {
        return new JChannelFactory(this);
    }

    public ServiceBuilder<ChannelFactory> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.environment).setInitialMode(ServiceController.Mode.ON_DEMAND);
        for (Dependency dependency : this.protocols) {
            dependency.register(builder);
        }
        return new CompositeDependency(new Dependency[]{this.transport, this.relay}).register(builder);
    }

    public Builder<ChannelFactory> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.statisticsEnabled = StackResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        Resource resource = context.readResourceFromRoot(this.address, false);
        Iterator transports = resource.getChildren(TransportResourceDefinition.WILDCARD_PATH.getKey()).iterator();
        if (!transports.hasNext()) {
            throw JGroupsLogger.ROOT_LOGGER.transportNotDefined(this.getName());
        }
        this.transport = new InjectedValueDependency((ServiceNameProvider)new SingletonProtocolServiceNameProvider(this.address, ((Resource.ResourceEntry)transports.next()).getPathElement()), TransportConfiguration.class);
        Set entries = resource.getChildren(ProtocolResourceDefinition.WILDCARD_PATH.getKey());
        this.protocols = new ArrayList<ValueDependency<ProtocolConfiguration<? extends Protocol>>>(entries.size());
        for (Resource.ResourceEntry entry : entries) {
            this.protocols.add((ValueDependency<ProtocolConfiguration<? extends Protocol>>)new InjectedValueDependency((ServiceNameProvider)new ProtocolServiceNameProvider(this.address, entry.getPathElement()), ProtocolConfiguration.class));
        }
        this.relay = resource.hasChild(RelayResourceDefinition.PATH) ? new InjectedValueDependency((ServiceNameProvider)new SingletonProtocolServiceNameProvider(this.address, RelayResourceDefinition.PATH), RelayConfiguration.class) : null;
        return this;
    }

    public String getName() {
        return this.address.getLastElement().getValue();
    }

    public TransportConfiguration<? extends TP> getTransport() {
        return (TransportConfiguration)this.transport.getValue();
    }

    public List<ProtocolConfiguration<? extends Protocol>> getProtocols() {
        ArrayList<ProtocolConfiguration<? extends Protocol>> protocols = new ArrayList<ProtocolConfiguration<? extends Protocol>>(this.protocols.size());
        for (Value value : this.protocols) {
            ProtocolConfiguration protocol = (ProtocolConfiguration)value.getValue();
            protocols.add((ProtocolConfiguration<? extends Protocol>)protocol);
        }
        return protocols;
    }

    public String getNodeName() {
        return ((ServerEnvironment)this.environment.getValue()).getNodeName();
    }

    public Optional<RelayConfiguration> getRelay() {
        return this.relay != null ? Optional.of(this.relay.getValue()) : Optional.empty();
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }
}

