/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.jgroups.subsystem.MulticastTransportConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.TransportConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jgroups.protocols.TP;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;

public class TransportRegistration
implements Registration<ManagementResourceRegistration> {
    private final ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory;

    public TransportRegistration(ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory) {
        this.parentBuilderFactory = parentBuilderFactory;
    }

    public void register(ManagementResourceRegistration registration) {
        new TransportResourceDefinition(new TransportResourceServiceBuilderFactory(), this.parentBuilderFactory).register(registration);
    }

    static class TransportResourceServiceBuilderFactory<T extends TP>
    implements ResourceServiceBuilderFactory<TransportConfiguration<T>> {
        TransportResourceServiceBuilderFactory() {
        }

        public ResourceServiceBuilder<TransportConfiguration<T>> createBuilder(PathAddress address) {
            return MulticastTransport.contains(address.getLastElement().getValue()) ? new MulticastTransportConfigurationBuilder(address) : new TransportConfigurationBuilder(address);
        }
    }

    static enum MulticastTransport {
        UDP;


        static boolean contains(String name) {
            for (MulticastTransport protocol : EnumSet.allOf(MulticastTransport.class)) {
                if (!name.equals(protocol.name())) continue;
                return true;
            }
            return false;
        }
    }
}

