/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v51.access;

import javax.transaction.Synchronization;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.infinispan.hibernate.cache.commons.access.SessionAccess;

public class SessionAccessImpl
implements SessionAccess {
    public SessionAccess.TransactionCoordinatorAccess getTransactionCoordinator(Object session) {
        return session == null ? null : new TransactionCoordinatorAccessImpl(this.unwrap(session).getTransactionCoordinator());
    }

    public long getTimestamp(Object session) {
        return this.unwrap(session).getTimestamp();
    }

    private SessionImplementor unwrap(Object session) {
        return (SessionImplementor)session;
    }

    private static final class TransactionCoordinatorAccessImpl
    implements SessionAccess.TransactionCoordinatorAccess {
        private final TransactionCoordinator txCoordinator;

        public TransactionCoordinatorAccessImpl(TransactionCoordinator txCoordinator) {
            this.txCoordinator = txCoordinator;
        }

        public void registerLocalSynchronization(Synchronization sync) {
            this.txCoordinator.getLocalSynchronizations().registerSynchronization(sync);
        }

        public IsolationDelegate createIsolationDelegate() {
            return this.txCoordinator.createIsolationDelegate();
        }

        public boolean isJoined() {
            return this.txCoordinator.isJoined();
        }
    }
}

